/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.mbari.sql.DBException;
import org.mbari.sql.IQueryable;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableImpl
implements IQueryable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final DateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private final String jdbcPassword;
    private final String jdbcUrl;
    private final String jdbcUsername;

    public QueryableImpl(String jdbcUrl, String jdbcUsername, String jdbcPassword, String driverClass) {
        this.jdbcUrl = jdbcUrl;
        this.jdbcUsername = jdbcUsername;
        this.jdbcPassword = jdbcPassword;
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException ex) {
            throw new DBException("Failed to initialize driver class:" + driverClass, ex);
        }
    }

    @Override
    public QueryResults executeQuery(String sql) {
        QueryFunction<QueryResults> queryFunction = new QueryFunction<QueryResults>(){

            @Override
            public QueryResults apply(ResultSet resultsSet) throws SQLException {
                return new QueryResults(resultsSet);
            }
        };
        return this.executeQueryFunction(sql, queryFunction);
    }

    @Override
    public <T> T executeQueryFunction(String query, QueryFunction<T> queryFunction) {
        this.log.debug("Executing SQL query: \n\t" + query);
        T object = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement(1003, 1007);
            ResultSet rs = stmt.executeQuery(query);
            object = queryFunction.apply(rs);
            rs.close();
            stmt.close();
            connection.close();
        }
        catch (Exception e) {
            if (connection != null) {
                this.log.error("Failed to execute the following SQL on " + this.jdbcUrl + ":\n" + query, e);
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Failed to close database connection", ex);
                }
            }
            throw new DBException("Failed to execute the following SQL on " + this.jdbcUrl + ": " + query, e);
        }
        return object;
    }

    public int executeUpdate(String updateSql) {
        this.log.debug("Executing SQL update: \n\t" + updateSql);
        int n = 0;
        Connection connection = null;
        try {
            connection = this.getConnection();
            Statement stmt = connection.createStatement(1003, 1008);
            n = stmt.executeUpdate(updateSql);
            stmt.close();
            connection.close();
        }
        catch (Exception e) {
            if (connection != null) {
                this.log.error("Failed to execute the following SQL on " + this.jdbcUrl + ":\n" + updateSql, e);
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Failed to close database connection", ex);
                }
            }
            throw new DBException("Failed to execute the following SQL on " + this.jdbcUrl + ": " + updateSql, e);
        }
        return n;
    }

    public Connection getConnection() throws SQLException {
        this.log.debug("Opening JDBC connection:" + this.jdbcUsername + " @ " + this.jdbcUrl);
        Connection connection = DriverManager.getConnection(this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
        return connection;
    }

    public void close() {
    }
}

