/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import rx.Scheduler;
import rx.annotations.Experimental;
import rx.internal.schedulers.ExecutorScheduler;
import rx.internal.schedulers.GenericScheduledExecutorService;
import rx.internal.schedulers.ImmediateScheduler;
import rx.internal.schedulers.SchedulerLifecycle;
import rx.internal.schedulers.TrampolineScheduler;
import rx.internal.util.RxRingBuffer;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;
import rx.schedulers.TestScheduler;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final AtomicReference<Schedulers> INSTANCE = new AtomicReference();

    private static Schedulers getInstance() {
        Schedulers current;
        while ((current = INSTANCE.get()) == null) {
            current = new Schedulers();
            if (INSTANCE.compareAndSet(null, current)) {
                return current;
            }
            current.shutdownInstance();
        }
        return current;
    }

    private Schedulers() {
        RxJavaSchedulersHook hook = RxJavaPlugins.getInstance().getSchedulersHook();
        Scheduler c = hook.getComputationScheduler();
        this.computationScheduler = c != null ? c : RxJavaSchedulersHook.createComputationScheduler();
        Scheduler io = hook.getIOScheduler();
        this.ioScheduler = io != null ? io : RxJavaSchedulersHook.createIoScheduler();
        Scheduler nt = hook.getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : RxJavaSchedulersHook.createNewThreadScheduler();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.INSTANCE;
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.INSTANCE;
    }

    public static Scheduler newThread() {
        return Schedulers.getInstance().newThreadScheduler;
    }

    public static Scheduler computation() {
        return Schedulers.getInstance().computationScheduler;
    }

    public static Scheduler io() {
        return Schedulers.getInstance().ioScheduler;
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    @Experimental
    public static void reset() {
        Schedulers s2 = INSTANCE.getAndSet(null);
        if (s2 != null) {
            s2.shutdownInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start() {
        Schedulers s2 = Schedulers.getInstance();
        s2.startInstance();
        Schedulers schedulers = s2;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.start();
            RxRingBuffer.SPSC_POOL.start();
            RxRingBuffer.SPMC_POOL.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Schedulers s2 = Schedulers.getInstance();
        s2.shutdownInstance();
        Schedulers schedulers = s2;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.shutdown();
            RxRingBuffer.SPSC_POOL.shutdown();
            RxRingBuffer.SPMC_POOL.shutdown();
        }
    }

    synchronized void startInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).start();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).start();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).start();
        }
    }

    synchronized void shutdownInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).shutdown();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).shutdown();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).shutdown();
        }
    }
}

