/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.internal.util.RxRingBuffer;

public final class BlockingOperatorToIterator {
    private BlockingOperatorToIterator() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Iterator<T> toIterator(Observable<? extends T> source) {
        SubscriberIterator subscriber = new SubscriberIterator();
        source.materialize().subscribe(subscriber);
        return subscriber;
    }

    public static final class SubscriberIterator<T>
    extends Subscriber<Notification<? extends T>>
    implements Iterator<T> {
        static final int LIMIT = 3 * RxRingBuffer.SIZE / 4;
        private final BlockingQueue<Notification<? extends T>> notifications = new LinkedBlockingQueue<Notification<? extends T>>();
        private Notification<? extends T> buf;
        private int received;

        @Override
        public void onStart() {
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
            this.notifications.offer(Notification.createOnError(e));
        }

        @Override
        public void onNext(Notification<? extends T> args) {
            this.notifications.offer(args);
        }

        @Override
        public boolean hasNext() {
            if (this.buf == null) {
                this.buf = this.take();
                ++this.received;
                if (this.received >= LIMIT) {
                    this.request(this.received);
                    this.received = 0;
                }
            }
            if (this.buf.isOnError()) {
                throw Exceptions.propagate(this.buf.getThrowable());
            }
            return !this.buf.isOnCompleted();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T result2 = this.buf.getValue();
                this.buf = null;
                return result2;
            }
            throw new NoSuchElementException();
        }

        private Notification<? extends T> take() {
            try {
                Notification poll = (Notification)this.notifications.poll();
                if (poll != null) {
                    return poll;
                }
                return this.notifications.take();
            }
            catch (InterruptedException e) {
                this.unsubscribe();
                throw Exceptions.propagate(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator");
        }
    }
}

