/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.util.UtilityFunctions;

public final class BackpressureUtils {
    static final long COMPLETED_MASK = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    private BackpressureUtils() {
        throw new IllegalStateException("No instances!");
    }

    @Deprecated
    public static <T> long getAndAddRequest(AtomicLongFieldUpdater<T> requested, T object, long n) {
        long next2;
        long current;
        while (!requested.compareAndSet(object, current = requested.get(object), next2 = BackpressureUtils.addCap(current, n))) {
        }
        return current;
    }

    public static long getAndAddRequest(AtomicLong requested, long n) {
        long next2;
        long current;
        while (!requested.compareAndSet(current = requested.get(), next2 = BackpressureUtils.addCap(current, n))) {
        }
        return current;
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && b != 0L && u / b != a) {
            u = Long.MAX_VALUE;
        }
        return u;
    }

    public static long addCap(long a, long b) {
        long u = a + b;
        if (u < 0L) {
            u = Long.MAX_VALUE;
        }
        return u;
    }

    public static <T> void postCompleteDone(AtomicLong requested, Queue<T> queue, Subscriber<? super T> actual) {
        BackpressureUtils.postCompleteDone(requested, queue, actual, UtilityFunctions.identity());
    }

    public static <T> boolean postCompleteRequest(AtomicLong requested, long n, Queue<T> queue, Subscriber<? super T> actual) {
        return BackpressureUtils.postCompleteRequest(requested, n, queue, actual, UtilityFunctions.identity());
    }

    public static <T, R> void postCompleteDone(AtomicLong requested, Queue<T> queue, Subscriber<? super R> actual, Func1<? super T, ? extends R> exitTransform) {
        long u;
        long r;
        do {
            if (((r = requested.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!requested.compareAndSet(r, u = r | Long.MIN_VALUE));
        if (r != 0L) {
            BackpressureUtils.postCompleteDrain(requested, queue, actual, exitTransform);
        }
    }

    public static <T, R> boolean postCompleteRequest(AtomicLong requested, long n, Queue<T> queue, Subscriber<? super R> actual, Func1<? super T, ? extends R> exitTransform) {
        long c;
        long r;
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        if (n == 0L) {
            return (requested.get() & Long.MIN_VALUE) == 0L;
        }
        do {
            r = requested.get();
            c = r & Long.MIN_VALUE;
            long u = r & Long.MAX_VALUE;
            long v = BackpressureUtils.addCap(u, n);
        } while (!requested.compareAndSet(r, v |= c));
        if (r == Long.MIN_VALUE) {
            BackpressureUtils.postCompleteDrain(requested, queue, actual, exitTransform);
            return false;
        }
        return c == 0L;
    }

    static <T, R> void postCompleteDrain(AtomicLong requested, Queue<T> queue, Subscriber<? super R> subscriber, Func1<? super T, ? extends R> exitTransform) {
        long r = requested.get();
        if (r == Long.MAX_VALUE) {
            while (true) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                T v = queue.poll();
                if (v == null) {
                    subscriber.onCompleted();
                    return;
                }
                subscriber.onNext(exitTransform.call(v));
            }
        }
        long e = Long.MIN_VALUE;
        while (true) {
            if (e != r) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                T v = queue.poll();
                if (v == null) {
                    subscriber.onCompleted();
                    return;
                }
                subscriber.onNext(exitTransform.call(v));
                ++e;
                continue;
            }
            if (e == r) {
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                if (queue.isEmpty()) {
                    subscriber.onCompleted();
                    return;
                }
            }
            if ((r = requested.get()) != e) continue;
            r = requested.addAndGet(-(e & Long.MAX_VALUE));
            if (r == Long.MIN_VALUE) {
                return;
            }
            e = Long.MIN_VALUE;
        }
    }

    public static long produced(AtomicLong requested, long n) {
        long next2;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            next2 = current - n;
            if (next2 >= 0L) continue;
            throw new IllegalStateException("More produced than requested: " + next2);
        } while (!requested.compareAndSet(current, next2));
        return next2;
    }
}

