/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.ocean;

public class Seawater {
    private static double C3515 = 42.914;
    private static double EARTH_RADIUS = 6371000.0;
    private static double OMEGA = 7.292115E-5;
    private static double GDEF = 9.8;
    private static double T0 = 273.15;
    private static double MS = 0.0314038218;
    private static double CP0 = 3991.86795711963;
    private static double SSO = 35.16504;
    private static double R = 8.314472;
    private static double SON_CL = 1.80655;
    private static double P0 = 101325.0;
    private static double ATOMIC_WEIGHT = 31.4038218;
    private static double VALENCE_FACTOR = 1.2452898;

    private Seawater() {
    }

    public static double atg(double salinity, double temperature, double pressure) {
        double A0 = 3.5803E-5;
        double A1 = 8.5258E-6;
        double A2 = -6.836E-8;
        double A3 = 6.6228E-10;
        double B0 = 1.8932E-6;
        double B1 = -4.2393E-8;
        double C0 = 1.8741E-8;
        double C1 = -6.7795E-10;
        double C2 = 8.733E-12;
        double C3 = -5.4481E-14;
        double D0 = -1.1351E-10;
        double D1 = 2.7759E-12;
        double E0 = -4.6206E-13;
        double E1 = 1.8676E-14;
        double E2 = -2.1687E-16;
        return A0 + (A1 + (A2 + A3 * temperature) * temperature) * temperature + (B0 + B1 * temperature) * (salinity - 35.0) + (C0 + (C1 + (C2 + C3 * temperature) * temperature) * temperature + (D0 + D1 * temperature) * (salinity - 35.0)) * pressure + (E0 + (E1 + E2 * temperature) * temperature) * pressure * pressure;
    }

    public static double bulkmod(double salinity, double temperature, double pressure) {
        double E0 = 19652.21;
        double E1 = 148.4206;
        double E2 = -2.327105;
        double E3 = 0.01360477;
        double E4 = -5.155288E-5;
        double F0 = 54.6746;
        double F1 = -0.603459;
        double F2 = 0.0109987;
        double F3 = -6.167E-5;
        double G0 = 0.07944;
        double G1 = 0.016483;
        double G2 = -5.3009E-4;
        double H0 = 3.239908;
        double H1 = 0.00143713;
        double H2 = 1.16092E-4;
        double H3 = -5.77905E-7;
        double I0 = 0.0022838;
        double I1 = -1.0981E-5;
        double I2 = -1.6078E-6;
        double J0 = 1.91075E-4;
        double K0 = 8.50935E-5;
        double K1 = -6.12293E-6;
        double K2 = 5.2787E-8;
        double M0 = -9.9348E-7;
        double M1 = 2.0816E-8;
        double M2 = 9.1697E-10;
        double PRESS = pressure / 10.0;
        double KW = E0 + (E1 + (E2 + (E3 + E4 * temperature) * temperature) * temperature) * temperature;
        double AW = H0 + (H1 + (H2 + H3 * temperature) * temperature) * temperature;
        double BW = K0 + (K1 + K2 * temperature) * temperature;
        double A = AW + (I0 + (I1 + I2 * temperature) * temperature) * salinity + J0 * salinity * Math.sqrt(salinity);
        double B = BW + (M0 + (M1 + M2 * temperature) * temperature) * salinity;
        double F = (F0 + (F1 + (F2 + F3 * temperature) * temperature) * temperature) * salinity;
        double G = (G0 + (G1 + G2 * temperature) * temperature) * salinity * Math.sqrt(salinity);
        double KST0 = KW + F + G;
        return KST0 + (A + B * PRESS) * PRESS;
    }

    public static double delta(double salinity, double temperature, double pressure) {
        return 100000.0 * (1.0 / Seawater.density(salinity, temperature, pressure) - 1.0 / Seawater.density(35.0, 0.0, pressure));
    }

    public static double delta(double salinity, double temperature) {
        return Seawater.delta(salinity, temperature, 0.0);
    }

    public static double density(double S, double T, double P) {
        double A0 = 999.842594;
        double A1 = 0.06793952;
        double A2 = -0.00909529;
        double A3 = 1.001685E-4;
        double A4 = -1.120083E-6;
        double A5 = 6.536332E-9;
        double B0 = 0.824493;
        double B1 = -0.0040899;
        double B2 = 7.6438E-5;
        double B3 = -8.2467E-7;
        double B4 = 5.3875E-9;
        double C0 = -0.00572466;
        double C1 = 1.0227E-4;
        double C2 = -1.6546E-6;
        double D0 = 4.8314E-4;
        double RHOW = A0 + (A1 + (A2 + (A3 + (A4 + A5 * T) * T) * T) * T) * T;
        double B = (B0 + (B1 + (B2 + (B3 + B4 * T) * T) * T) * T) * S;
        double C = (C0 + (C1 + C2 * T) * T) * S * Math.sqrt(S);
        double D = D0 * S * S;
        double RHO = RHOW + B + C + D;
        double KSTP = Seawater.bulkmod(S, T, P);
        return (RHO /= 1.0 - P / (10.0 * KSTP)) / 1000.0;
    }

    public static double density(double S, double T) {
        return Seawater.density(S, T, 0.0);
    }

    public static double depth(double pressure, double latitude) {
        double C1 = 9.72659;
        double C2 = -2.2512E-5;
        double C3 = 2.279E-10;
        double C4 = -1.82E-15;
        double G0 = 9.780318;
        double G1 = 0.0052788;
        double G2 = 2.36E-5;
        double GAMMA = 2.184E-6;
        double X = Math.pow(Math.sin(Math.PI * latitude / 180.0), 2.0);
        double GRAVITY = G0 * (1.0 + (G1 + G2 * X) * X) + GAMMA / 2.0 * pressure;
        double Z = (C1 + (C2 + (C3 + C4 * pressure) * pressure) * pressure) * pressure;
        return Z / GRAVITY;
    }

    public static double freeze(double salinity, double pressure) {
        double A0 = -0.0575;
        double A1 = 0.001710523;
        double A2 = -2.154996E-4;
        double B = -7.53E-4;
        return (A0 + A1 * Math.sqrt(salinity) + A2 * salinity) * salinity + B * pressure;
    }

    public static double salinity(double conductivity, double temperature, double pressure) {
        double[] a = new double[]{0.008, -0.1692, 25.3851, 14.0941, -7.0261, 2.7081};
        double[] b = new double[]{5.0E-4, -0.0056, -0.0066, -0.0375, 0.0636, -0.0144};
        double[] c = new double[]{0.6766097, 0.0200564, 1.104259E-4, -6.9698E-7, 1.0031E-9};
        double[] d = new double[]{0.03426, 4.464E-4, 0.4215, -0.003107};
        double[] e = new double[]{2.07E-5, -6.37E-10, 3.989E-15};
        double k = 0.0162;
        double ee = (e[0] + (e[1] + e[2] * pressure) * pressure) * pressure;
        double dd = 1.0 + (d[0] + d[1] * temperature) * temperature + (d[2] + d[3] * temperature) * conductivity;
        double rp = 1.0 + ee / dd;
        double rt = c[0] + (c[1] + (c[2] + (c[3] + c[4] * temperature) * temperature) * temperature) * temperature;
        double rr = conductivity / (rp * rt);
        double rrt = rr > 0.0 ? Math.sqrt(rr) : 0.0;
        double bb = b[0] + (b[1] + (b[2] + (b[3] + (b[4] + b[5] * rrt) * rrt) * rrt) * rrt) * rrt;
        double delS = (temperature - 15.0) * bb / (1.0 + k * (temperature - 15.0));
        double s2 = a[0] + (a[1] + (a[2] + (a[3] + (a[4] + a[5] * rrt) * rrt) * rrt) * rrt) * rrt + delS;
        return s2 < 0.0 ? 0.0 : s2;
    }

    public static double salinity(double conductivity, double temperature) {
        return Seawater.salinity(conductivity, temperature, 0.0);
    }

    public static double sigmat(double salinity, double temperature) {
        return 1000.0 * (Seawater.density(salinity, temperature, 0.0) - 1.0);
    }

    public static double spiciness(double salinity, double theta, double pressure) {
        double a = 0.31171 - 2.1029E-6 * pressure - 2.7917E-9 * Math.pow(pressure, 2.0);
        double b = -0.010925 + 7.5657E-7 * pressure + 4.9133E-11 * Math.pow(pressure, 2.0);
        double c = -0.073732 - 4.8778E-6 * pressure + 1.085E-9 * Math.pow(pressure, 2.0);
        double s0 = 35.0;
        return (Seawater.density(s0, 0.0, pressure) - 1.0) * 1000.0 - (Seawater.density(s0 - (1.0 + c) * (salinity - s0), theta + (salinity - s0) * (a + b * theta), pressure) - 1.0) * 1000.0;
    }

    public static double svel(double salinity, double temperature, double pressure) {
        double a00 = 1.389;
        double a01 = -0.01262;
        double a02 = 7.164E-5;
        double a03 = 2.006E-6;
        double a04 = -3.21E-8;
        double a10 = 9.4742E-5;
        double a11 = -1.258E-5;
        double a12 = -6.4885E-8;
        double a13 = 1.0507E-8;
        double a14 = -2.0122E-10;
        double a20 = -3.9064E-7;
        double a21 = 9.1041E-9;
        double a22 = -1.6002E-10;
        double a23 = 7.988E-12;
        double a30 = 1.1E-10;
        double a31 = 6.649E-12;
        double a32 = -3.389E-13;
        double b00 = -0.01922;
        double b01 = -4.42E-5;
        double b10 = 7.3637E-5;
        double b11 = 1.7945E-7;
        double c00 = 1402.388;
        double c01 = 5.03711;
        double c02 = -0.0580852;
        double c03 = 3.342E-4;
        double c04 = -1.478E-6;
        double c05 = 3.1464E-9;
        double c10 = 0.153563;
        double c11 = 6.8982E-4;
        double c12 = -8.1788E-6;
        double c13 = 1.3621E-7;
        double c14 = -6.1185E-10;
        double c20 = 3.126E-5;
        double c21 = -1.7107E-6;
        double c22 = 2.5974E-8;
        double c23 = -2.5335E-10;
        double c24 = 1.0405E-12;
        double c30 = -9.7729E-9;
        double c31 = 3.8504E-10;
        double c32 = -2.3643E-12;
        double d00 = 0.001727;
        double d10 = -7.9836E-6;
        double p2 = pressure / 10.0;
        double cw = c00 + (c01 + (c02 + (c03 + (c04 + c05 * temperature) * temperature) * temperature) * temperature) * temperature + (c10 + (c11 + (c12 + (c13 + c14 * temperature) * temperature) * temperature) * temperature + (c20 + (c21 + (c22 + (c23 + c24 * temperature) * temperature) * temperature) * temperature + (c30 + (c31 + c32 * temperature) * temperature) * p2) * p2) * p2;
        double a = a00 + (a01 + (a02 + (a03 + a04 * temperature) * temperature) * temperature) * temperature + (a10 + (a11 + (a12 + (a13 + a14 * temperature) * temperature) * temperature) * temperature + (a20 + (a21 + (a22 + a23 * temperature) * temperature) * temperature + (a30 + (a31 + a32 * temperature) * temperature) * p2) * p2) * p2;
        double b = b00 + b01 * temperature + (b10 + b11 * temperature) * p2;
        double d = d00 + d10 * p2;
        return cw + (a + b * Math.sqrt(salinity) + d * salinity) * salinity;
    }

    public static double theta(double salinity, double temperature, double p0, double pr) {
        double p = p0;
        double t2 = temperature;
        double h = pr - p;
        double xk = h * Seawater.atg(salinity, t2, p);
        t2 += 0.5 * xk;
        double q = xk;
        xk = h * Seawater.atg(salinity, t2, p += 0.5 * h);
        t2 += 0.29289322 * (xk - q);
        q = 0.58578644 * xk + 0.121320344 * q;
        xk = h * Seawater.atg(salinity, t2, p);
        t2 += 1.70710678 * (xk - q);
        q = 3.414213562 * xk - 4.121320344 * q;
        xk = h * Seawater.atg(salinity, t2, p += 0.5 * h);
        return t2 + (xk - 2.0 * q) / 6.0;
    }

    public static double theta(double salinity, double temperature, double p0) {
        return Seawater.theta(salinity, temperature, p0, 0.0);
    }
}

