/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.movie;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.mbari.util.IObservable;
import org.mbari.util.IObserver;
import org.mbari.util.ObservableSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timecode
implements Comparable,
IObservable {
    public static final String EMPTY_TIMECODE_STRING = "--:--:--:--";
    private static final Logger log = LoggerFactory.getLogger(Timecode.class);
    private static final NumberFormat format = new DecimalFormat(){
        {
            this.setMaximumFractionDigits(0);
            this.setMinimumIntegerDigits(2);
            this.setMaximumIntegerDigits(2);
        }
    };
    private double frameRate = 30.0;
    private Representation representation = Representation.TIMECODE;
    private final ObservableSupport os = new ObservableSupport();
    protected boolean isValid = false;
    private int frame;
    private double frames;
    private int hour;
    private int minute;
    private int second;

    public Timecode() {
    }

    public Timecode(double frames) {
        this.setFrames(frames);
    }

    public Timecode(String timecode) throws NumberFormatException {
        this.setTimecode(timecode);
    }

    public Timecode(Timecode timecode) {
        this(timecode.getFrames(), timecode.getFrameRate());
    }

    public Timecode(double frames, double frameRate) {
        this.setFrameRate(frameRate);
        this.setFrames(frames);
    }

    public Timecode(String timecode, double frameRate) throws NumberFormatException {
        this.setFrameRate(frameRate);
        this.setTimecode(timecode);
    }

    public void addFrames(double frames) {
        this.frames += frames;
    }

    public void addObserver(IObserver observer) {
        this.os.add(observer);
    }

    public int compareTo(Object object) {
        return (int)this.diffFrames((Timecode)object);
    }

    public double diffFrames(Timecode that) {
        return this.getFrames() - that.getFrames();
    }

    public boolean equals(Object object) {
        return this.diffFrames((Timecode)object) == 0.0;
    }

    public int getFrame() {
        return this.frame;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public double getFrames() {
        return this.frames;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public int getSecond() {
        return this.second;
    }

    public int hashCode() {
        return (int)(this.getFrames() / this.getFrameRate());
    }

    void notifyObservers() {
        this.os.notify(this, null);
    }

    public void removeAllObservers() {
        this.os.clear();
    }

    public void removeObserver(IObserver observer) {
        this.os.remove(observer);
    }

    public void setFrameRate(double frameRate) {
        if (frameRate != this.frameRate) {
            String timecode = this.toString();
            this.frameRate = frameRate;
            this.setTimecode(timecode);
        }
    }

    public void setFrames(double f) {
        this.frames = f;
        double frameRate = this.getFrameRate();
        this.hour = (int)Math.floor(f / 60.0 / 60.0 / frameRate);
        this.minute = (int)Math.floor((f -= (double)this.hour * 60.0 * 60.0 * frameRate) / 60.0 / frameRate);
        this.second = (int)Math.floor((f -= (double)this.minute * 60.0 * frameRate) / frameRate);
        this.frame = (int)Math.floor(f - (double)this.second * frameRate);
        this.isValid = true;
        this.notifyObservers();
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public void setTime(int h, int m, int s2, int f) {
        this.setFrames((double)((h * 60 + m) * 60 + s2) * this.getFrameRate() + (double)f);
    }

    public void setTimecode(String timecode) {
        block2: {
            try {
                int h = Integer.parseInt(timecode.substring(0, 2));
                int m = Integer.parseInt(timecode.substring(3, 5));
                int s2 = Integer.parseInt(timecode.substring(6, 8));
                int f = Integer.parseInt(timecode.substring(9, 11));
                this.setTime(h, m, s2, f);
            }
            catch (Exception e) {
                this.isValid = false;
                if (!log.isWarnEnabled()) break block2;
                log.warn("Illegal TimeCode format: '" + timecode + "'");
            }
        }
    }

    public String toString() {
        String out = EMPTY_TIMECODE_STRING;
        if (this.isValid) {
            StringBuffer b = new StringBuffer();
            b.append(format.format(this.getHour())).append(':');
            b.append(format.format(this.getMinute())).append(':');
            b.append(format.format(this.getSecond())).append(':');
            b.append(format.format(this.getFrame()));
            out = b.toString();
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Representation {
        TIMECODE,
        RUNTIME;

    }
}

