/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func2;
import rx.observers.SerializedSubscriber;

public final class OperatorWithLatestFrom<T, U, R>
implements Observable.Operator<R, T> {
    final Func2<? super T, ? super U, ? extends R> resultSelector;
    final Observable<? extends U> other;
    static final Object EMPTY = new Object();

    public OperatorWithLatestFrom(Observable<? extends U> other, Func2<? super T, ? super U, ? extends R> resultSelector) {
        this.other = other;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final SerializedSubscriber<R> s2 = new SerializedSubscriber<R>(child, false);
        child.add(s2);
        final AtomicReference<Object> current = new AtomicReference<Object>(EMPTY);
        Subscriber subscriber = new Subscriber<T>(s2, true){

            @Override
            public void onNext(T t) {
                Object o = current.get();
                if (o != EMPTY) {
                    try {
                        Object u = o;
                        Object result2 = OperatorWithLatestFrom.this.resultSelector.call(t, u);
                        s2.onNext(result2);
                    }
                    catch (Throwable e) {
                        Exceptions.throwOrReport(e, this);
                    }
                }
            }

            @Override
            public void onError(Throwable e) {
                s2.onError(e);
                s2.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s2.onCompleted();
                s2.unsubscribe();
            }
        };
        Subscriber otherSubscriber = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                current.set(t);
            }

            @Override
            public void onError(Throwable e) {
                s2.onError(e);
                s2.unsubscribe();
            }

            @Override
            public void onCompleted() {
                if (current.get() == EMPTY) {
                    s2.onCompleted();
                    s2.unsubscribe();
                }
            }
        };
        s2.add(subscriber);
        s2.add(otherSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
        return subscriber;
    }
}

