/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.solar;

import java.io.IOException;
import org.mbari.io.FlatFileReader;
import org.mbari.math.Matlib;
import org.mbari.util.SystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolarUtil {
    private static final Logger log = LoggerFactory.getLogger(SolarUtil.class);
    public static final double EARTH_ORBIT_ECCENTRICITY = 0.0167;
    static double[][] DOBSON_TABLE = new double[35][12];
    private static final double[] LAMBDA = new double[]{329.8, 331.8, 333.8, 335.9, 337.9, 339.8, 341.9, 343.8, 345.8, 347.9, 349.8, 351.9, 353.9, 355.9, 357.9, 360.0, 362.0, 364.1, 366.1, 367.8, 369.8, 371.9, 373.7, 375.5, 377.5, 379.4, 381.4, 383.4, 385.4, 387.4, 389.4, 391.2, 393.2, 395.0, 396.9, 398.9, 400.1, 402.0, 404.0, 406.0, 407.9, 409.9, 411.7, 413.7, 415.6, 417.6, 419.1, 421.1, 423.1, 424.8, 426.8, 428.6, 430.6, 432.6, 434.0, 435.9, 437.2, 439.2, 440.9, 442.8, 444.7, 446.4, 448.3, 450.3, 452.4, 454.4, 456.4, 458.4, 460.4, 462.4, 464.4, 466.4, 468.4, 470.4, 472.3, 474.3, 476.3, 478.3, 480.3, 482.3, 484.3, 486.3, 488.3, 489.3, 491.3, 493.3, 495.1, 497.1, 498.9, 500.9, 502.9, 504.9, 506.8, 508.8, 510.8, 512.8, 514.8, 516.8, 518.8, 520.0, 521.9, 523.9, 525.8, 527.8, 529.8, 531.6, 533.5, 535.4, 537.2, 539.2, 541.0, 543.0, 545.0, 547.0, 549.0, 550.8, 552.7, 554.7, 556.7, 558.7, 560.7, 562.7, 564.6, 566.6, 568.6, 570.6, 572.6, 574.6, 576.6, 578.5, 580.5, 582.5, 584.5, 586.5, 588.4, 590.4, 592.3, 594.3, 596.3, 598.3, 600.3, 602.3, 604.3, 606.3, 608.0, 610.0, 612.0, 614.0, 616.0, 618.0, 620.0, 622.0, 623.9, 625.9, 627.9, 629.9, 631.9, 633.9, 635.9, 637.9, 639.9, 641.9, 643.9, 645.9, 647.9, 649.9, 651.9, 653.9, 655.9, 662.1, 666.3, 679.0, 709.0};
    private static final double[] E0 = new double[]{107.65, 98.7, 95.0, 91.0, 88.95, 100.85, 95.75, 87.85, 94.4, 95.4, 98.4, 97.3, 115.55, 108.0, 76.3, 108.85, 106.9, 101.6, 128.8, 117.85, 123.05, 119.0, 98.45, 104.7, 139.0, 122.95, 114.8, 74.9, 103.05, 99.9, 117.3, 129.95, 76.55, 130.1, 88.65, 160.6, 170.15, 178.55, 162.2, 164.55, 169.15, 166.0, 181.35, 173.3, 178.85, 169.25, 165.6, 181.85, 165.0, 175.1, 162.0, 164.9, 123.0, 179.35, 173.65, 185.55, 184.35, 167.35, 179.35, 195.55, 194.8, 185.15, 202.0, 213.0, 199.65, 201.3, 205.9, 201.6, 202.15, 209.45, 199.45, 195.65, 201.1, 194.3, 201.85, 203.2, 197.2, 205.05, 206.4, 204.15, 201.2, 171.5, 187.75, 193.95, 188.4, 193.5, 198.9, 199.35, 192.1, 182.35, 192.2, 191.55, 196.7, 192.75, 193.2, 189.5, 185.25, 169.2, 173.3, 181.8, 188.1, 191.35, 183.15, 180.8, 194.1, 193.4, 184.35, 193.75, 184.95, 184.25, 180.5, 185.45, 188.75, 184.35, 186.75, 185.8, 185.35, 188.1, 180.05, 179.95, 180.4, 185.35, 182.9, 182.2, 133.7, 178.9, 187.25, 184.25, 184.15, 180.25, 184.0, 184.4, 183.3, 178.95, 174.5, 173.85, 177.65, 178.7, 179.6, 173.15, 172.45, 170.55, 175.85, 173.7, 173.0, 172.0, 173.8, 169.95, 166.9, 172.5, 171.5, 169.05, 165.7, 165.8, 168.15, 164.0, 165.0, 164.15, 165.7, 166.25, 162.05, 160.95, 162.0, 161.2, 161.2, 156.45, 160.2, 159.05, 137.3, 157.45, 155.0, 146.95, 138.0};
    private static double[] OZONE_LAMBDA;
    private static double[] OZONE_ABSORPTION;

    public static final double[] getNeckelLabWavelengths() {
        double[] lambda = new double[LAMBDA.length];
        System.arraycopy(LAMBDA, 0, lambda, 0, LAMBDA.length);
        return lambda;
    }

    public static final double[] getNeckelLabIrradiance(double[] lambda) {
        return Matlib.interpolate(SolarUtil.getNeckelLabWavelengths(), SolarUtil.getNeckelLabIrradiance(), lambda);
    }

    public static final double[] getNeckelLabIrradiance() {
        double[] e0 = new double[E0.length];
        System.arraycopy(E0, 0, e0, 0, E0.length);
        return e0;
    }

    public static final double[] getOzoneWavelengths() throws IOException {
        double[] lambda = new double[OZONE_LAMBDA.length];
        System.arraycopy(OZONE_LAMBDA, 0, lambda, 0, OZONE_LAMBDA.length);
        return lambda;
    }

    public static final double[] getOzoneAbsorption() throws IOException {
        double[] e0 = new double[OZONE_ABSORPTION.length];
        System.arraycopy(OZONE_ABSORPTION, 0, e0, 0, OZONE_ABSORPTION.length);
        return e0;
    }

    public static final double[] getOzoneAbsorption(double[] lambda) throws IOException {
        return Matlib.interpolate(SolarUtil.getOzoneWavelengths(), SolarUtil.getOzoneAbsorption(), lambda);
    }

    public static double getEarthSunIrradianceCorrectionLP(int dayOfYear) {
        double e = 0.0167;
        return Math.pow(1.0 + e * Math.cos(Math.PI * 2 * ((double)dayOfYear - 3.0) / 365.0), 2.0);
    }

    public static double getEarthSunDistanceLP(int dayOfYear) {
        return 1.0 / SolarUtil.getEarthSunIrradianceCorrectionLP(dayOfYear);
    }

    public static double[] getCorrectedETIrradiance(double[] lambda, int dayOfYear) {
        double[] e0 = SolarUtil.getNeckelLabIrradiance(lambda);
        double earthSunDistance = SolarUtil.getEarthSunIrradianceCorrectionLP(dayOfYear);
        double[] Es = new double[e0.length];
        for (int i = 0; i < e0.length; ++i) {
            Es[i] = e0[i] * earthSunDistance;
        }
        return Es;
    }

    public static double estimateDobson(int month, double lat) {
        double dobson;
        --month;
        if (lat >= 85.0) {
            dobson = DOBSON_TABLE[0][month];
        } else if (lat <= -85.0) {
            dobson = DOBSON_TABLE[34][month];
        } else if (lat >= 0.0) {
            int i1 = 17 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (DOBSON_TABLE[i2][month] - DOBSON_TABLE[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            dobson = DOBSON_TABLE[i1][month] + fac * diffLat;
        } else {
            int i1 = 18 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (DOBSON_TABLE[i2][month] - DOBSON_TABLE[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            dobson = DOBSON_TABLE[i1][month] + fac * diffLat;
        }
        return dobson;
    }

    static {
        try {
            FlatFileReader ffr = new FlatFileReader(SystemUtilities.getFile("/org/mbari/model/solar/ozone.txt"));
            OZONE_LAMBDA = ffr.getColumn(0);
            OZONE_ABSORPTION = ffr.getColumn(1);
        }
        catch (IOException e) {
            log.error("Failed to initialize class. Couldn't read ozone absorption", e);
            OZONE_LAMBDA = new double[]{Double.NaN};
            OZONE_ABSORPTION = new double[]{Double.NaN};
        }
        double[] dobsonTmp = new double[]{395.0, 395.0, 395.0, 395.0, 395.0, 392.0, 390.0, 387.0, 376.0, 354.0, 322.0, 292.0, 269.0, 254.0, 248.0, 246.0, 247.0, 251.0, 255.0, 260.0, 266.0, 271.0, 277.0, 286.0, 295.0, 306.0, 319.0, 334.0, 344.0, 344.0, 338.0, 331.0, 324.0, 320.0, 316.0, 433.0, 433.0, 433.0, 436.0, 432.0, 428.0, 426.0, 418.0, 402.0, 374.0, 338.0, 303.0, 278.0, 261.0, 251.0, 246.0, 248.0, 250.0, 254.0, 258.0, 262.0, 265.0, 270.0, 278.0, 286.0, 294.0, 303.0, 313.0, 322.0, 325.0, 324.0, 317.0, 306.0, 299.0, 294.0, 467.0, 470.0, 460.0, 459.0, 451.0, 441.0, 433.0, 420.0, 401.0, 377.0, 347.0, 316.0, 291.0, 271.0, 260.0, 254.0, 254.0, 255.0, 257.0, 259.0, 261.0, 264.0, 269.0, 277.0, 284.0, 289.0, 296.0, 305.0, 312.0, 315.0, 317.0, 312.0, 305.0, 299.0, 295.0, 467.0, 465.0, 462.0, 455.0, 444.0, 431.0, 421.0, 410.0, 395.0, 373.0, 348.0, 325.0, 304.0, 287.0, 275.0, 267.0, 261.0, 259.0, 258.0, 259.0, 260.0, 263.0, 271.0, 278.0, 284.0, 289.0, 297.0, 306.0, 314.0, 318.0, 319.0, 313.0, 302.0, 302.0, 302.0, 411.0, 414.0, 416.0, 415.0, 410.0, 406.0, 402.0, 394.0, 382.0, 363.0, 342.0, 324.0, 307.0, 291.0, 279.0, 271.0, 264.0, 260.0, 258.0, 257.0, 258.0, 264.0, 271.0, 281.0, 291.0, 303.0, 312.0, 318.0, 322.0, 323.0, 322.0, 322.0, 322.0, 322.0, 322.0, 371.0, 371.0, 370.0, 368.0, 367.0, 372.0, 375.0, 372.0, 360.0, 341.0, 323.0, 311.0, 301.0, 290.0, 282.0, 275.0, 268.0, 263.0, 259.0, 256.0, 258.0, 264.0, 273.0, 289.0, 306.0, 319.0, 327.0, 328.0, 328.0, 337.0, 337.0, 337.0, 337.0, 337.0, 337.0, 333.0, 332.0, 332.0, 334.0, 338.0, 346.0, 350.0, 346.0, 335.0, 321.0, 310.0, 302.0, 296.0, 289.0, 284.0, 280.0, 274.0, 268.0, 262.0, 259.0, 261.0, 268.0, 279.0, 295.0, 315.0, 331.0, 340.0, 342.0, 338.0, 344.0, 340.0, 340.0, 340.0, 340.0, 340.0, 311.0, 308.0, 308.0, 313.0, 320.0, 327.0, 330.0, 326.0, 319.0, 310.0, 303.0, 298.0, 291.0, 286.0, 283.0, 281.0, 277.0, 273.0, 268.0, 264.0, 266.0, 274.0, 288.0, 306.0, 327.0, 343.0, 353.0, 355.0, 351.0, 339.0, 325.0, 307.0, 294.0, 294.0, 294.0, 283.0, 291.0, 302.0, 308.0, 312.0, 317.0, 318.0, 313.0, 307.0, 300.0, 295.0, 290.0, 284.0, 279.0, 279.0, 279.0, 278.0, 276.0, 272.0, 270.0, 273.0, 282.0, 295.0, 313.0, 333.0, 348.0, 360.0, 367.0, 368.0, 353.0, 324.0, 291.0, 267.0, 253.0, 230.0, 299.0, 299.0, 299.0, 309.0, 315.0, 317.0, 317.0, 312.0, 302.0, 291.0, 283.0, 280.0, 275.0, 270.0, 268.0, 267.0, 263.0, 263.0, 265.0, 269.0, 277.0, 287.0, 301.0, 317.0, 336.0, 354.0, 371.0, 387.0, 402.0, 402.0, 374.0, 333.0, 294.0, 274.0, 259.0, 314.0, 314.0, 314.0, 314.0, 332.0, 332.0, 327.0, 322.0, 311.0, 297.0, 284.0, 276.0, 270.0, 263.0, 261.0, 260.0, 258.0, 259.0, 264.0, 270.0, 278.0, 286.0, 298.0, 311.0, 323.0, 335.0, 350.0, 366.0, 381.0, 390.0, 388.0, 376.0, 357.0, 346.0, 341.0, 358.0, 358.0, 358.0, 358.0, 358.0, 358.0, 353.0, 349.0, 338.0, 320.0, 299.0, 281.0, 267.0, 256.0, 252.0, 251.0, 251.0, 253.0, 257.0, 264.0, 272.0, 279.0, 287.0, 297.0, 307.0, 318.0, 332.0, 347.0, 358.0, 365.0, 366.0, 364.0, 358.0, 356.0, 353.0};
        int n = -1;
        for (int c = 0; c < 12; ++c) {
            for (int r = 0; r < 35; ++r) {
                SolarUtil.DOBSON_TABLE[r][c] = dobsonTmp[++n];
            }
        }
    }
}

