/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import rx.Subscription;
import rx.exceptions.Exceptions;

public final class SubscriptionList
implements Subscription {
    private LinkedList<Subscription> subscriptions;
    private volatile boolean unsubscribed;

    public SubscriptionList() {
    }

    public SubscriptionList(Subscription ... subscriptions) {
        this.subscriptions = new LinkedList<Subscription>(Arrays.asList(subscriptions));
    }

    public SubscriptionList(Subscription s2) {
        this.subscriptions = new LinkedList();
        this.subscriptions.add(s2);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s2) {
        if (s2.isUnsubscribed()) {
            return;
        }
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (!this.unsubscribed) {
                    LinkedList<Subscription> subs = this.subscriptions;
                    if (subs == null) {
                        this.subscriptions = subs = new LinkedList();
                    }
                    subs.add(s2);
                    return;
                }
            }
        }
        s2.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Subscription s2) {
        if (!this.unsubscribed) {
            boolean unsubscribe = false;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                LinkedList<Subscription> subs = this.subscriptions;
                if (this.unsubscribed || subs == null) {
                    return;
                }
                unsubscribe = subs.remove(s2);
            }
            if (unsubscribe) {
                s2.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        if (!this.unsubscribed) {
            LinkedList<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s2 : subscriptions) {
            try {
                s2.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.unsubscribed) {
            LinkedList<Subscription> list;
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                list = this.subscriptions;
                this.subscriptions = null;
            }
            SubscriptionList.unsubscribeFromAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            SubscriptionList subscriptionList = this;
            synchronized (subscriptionList) {
                return !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
            }
        }
        return false;
    }
}

