/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.util.OpenHashSet;
import rx.observables.ConnectableObservable;
import rx.schedulers.Timestamped;
import rx.subscriptions.Subscriptions;

public final class OperatorReplay<T>
extends ConnectableObservable<T> {
    final Observable<? extends T> source;
    final AtomicReference<ReplaySubscriber<T>> current;
    final Func0<? extends ReplayBuffer<T>> bufferFactory;
    static final Func0 DEFAULT_UNBOUNDED_FACTORY = new Func0(){

        @Override
        public Object call() {
            return new UnboundedReplayBuffer(16);
        }
    };

    public static <T, U, R> Observable<R> multicastSelector(final Func0<? extends ConnectableObservable<U>> connectableFactory, final Func1<? super Observable<U>, ? extends Observable<R>> selector) {
        return Observable.create(new Observable.OnSubscribe<R>(){

            @Override
            public void call(final Subscriber<? super R> child) {
                Observable observable;
                ConnectableObservable co;
                try {
                    co = (ConnectableObservable)connectableFactory.call();
                    observable = (Observable)selector.call(co);
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, child);
                    return;
                }
                observable.subscribe(child);
                co.connect((Action1<Subscription>)new Action1<Subscription>(){

                    @Override
                    public void call(Subscription t) {
                        child.add(t);
                    }
                });
            }
        });
    }

    public static <T> ConnectableObservable<T> observeOn(final ConnectableObservable<T> co, Scheduler scheduler) {
        final Observable observable = co.observeOn(scheduler);
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(final Subscriber<? super T> child) {
                observable.unsafeSubscribe(new Subscriber<T>(child){

                    @Override
                    public void onNext(T t) {
                        child.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e) {
                        child.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        child.onCompleted();
                    }
                });
            }
        };
        return new ConnectableObservable<T>(onSubscribe){

            @Override
            public void connect(Action1<? super Subscription> connection) {
                co.connect(connection);
            }
        };
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source) {
        return OperatorReplay.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, final int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return OperatorReplay.create(source);
        }
        return OperatorReplay.create(source, new Func0<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeBoundReplayBuffer(bufferSize);
            }
        });
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return OperatorReplay.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, long maxAge, TimeUnit unit, final Scheduler scheduler, final int bufferSize) {
        final long maxAgeInMillis = unit.toMillis(maxAge);
        return OperatorReplay.create(source, new Func0<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeAndTimeBoundReplayBuffer(bufferSize, maxAgeInMillis, scheduler);
            }
        });
    }

    static <T> ConnectableObservable<T> create(Observable<? extends T> source, final Func0<? extends ReplayBuffer<T>> bufferFactory) {
        final AtomicReference<ReplaySubscriber<T>> curr = new AtomicReference<ReplaySubscriber<T>>();
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> child) {
                ReplaySubscriber r;
                while ((r = (ReplaySubscriber)curr.get()) == null) {
                    ReplaySubscriber u = new ReplaySubscriber(curr, (ReplayBuffer)bufferFactory.call());
                    u.init();
                    if (!curr.compareAndSet(r, u)) continue;
                    r = u;
                    break;
                }
                InnerProducer inner2 = new InnerProducer(r, child);
                r.add(inner2);
                child.add(inner2);
                r.buffer.replay(inner2);
                child.setProducer(inner2);
            }
        };
        return new OperatorReplay<T>(onSubscribe, source, curr, bufferFactory);
    }

    private OperatorReplay(Observable.OnSubscribe<T> onSubscribe, Observable<? extends T> source, AtomicReference<ReplaySubscriber<T>> current, Func0<? extends ReplayBuffer<T>> bufferFactory) {
        super(onSubscribe);
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public void connect(Action1<? super Subscription> connection) {
        ReplaySubscriber<T> ps;
        boolean doConnect = false;
        while ((ps = this.current.get()) == null || ps.isUnsubscribed()) {
            ReplaySubscriber<T> u = new ReplaySubscriber<T>(this.current, this.bufferFactory.call());
            u.init();
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        connection.call(ps);
        if (doConnect) {
            this.source.unsafeSubscribe(ps);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAgeInMillis;
        final int limit;

        public SizeAndTimeBoundReplayBuffer(int limit, long maxAgeInMillis, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAgeInMillis = maxAgeInMillis;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timestamped<Object>(this.scheduler.now(), value);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timestamped)value).getValue();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev = (Node)this.get();
            Node next2 = (Node)prev.get();
            int e = 0;
            while (next2 != null) {
                if (this.size > this.limit) {
                    ++e;
                    --this.size;
                    prev = next2;
                    next2 = (Node)next2.get();
                    continue;
                }
                Timestamped v = (Timestamped)next2.value;
                if (v.getTimestampMillis() > timeLimit) break;
                ++e;
                --this.size;
                prev = next2;
                next2 = (Node)next2.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            Timestamped v;
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev = (Node)this.get();
            int e = 0;
            for (Node next2 = (Node)prev.get(); next2 != null && this.size > 1 && (v = (Timestamped)next2.value).getTimestampMillis() <= timeLimit; next2 = (Node)next2.get()) {
                ++e;
                --this.size;
                prev = next2;
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        public SizeBoundReplayBuffer(int limit) {
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        final NotificationLite<T> nl = NotificationLite.instance();
        Node tail;
        int size;
        long index;

        public BoundedReplayBuffer() {
            Node n;
            this.tail = n = new Node(null, 0L);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head2 = (Node)this.get();
            Node next2 = (Node)head2.get();
            if (next2 == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next2);
        }

        final void removeSome(int n) {
            Node head2 = (Node)this.get();
            while (n > 0) {
                head2 = (Node)head2.get();
                --n;
                --this.size;
            }
            this.setFirst(head2);
        }

        final void setFirst(Node n) {
            this.set(n);
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(this.nl.next(value));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e) {
            Object o = this.enterTransform(this.nl.error(e));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(this.nl.completed());
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                Node v;
                long r = output.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long e = 0L;
                Node node = (Node)output.index();
                if (node == null) {
                    node = (Node)this.get();
                    output.index = node;
                    output.addTotalRequested(node.index);
                }
                if (output.isUnsubscribed()) {
                    return;
                }
                while (r != 0L && (v = (Node)node.get()) != null) {
                    Object o = this.leaveTransform(v.value);
                    try {
                        if (this.nl.accept(output.child, o)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        output.index = null;
                        Exceptions.throwIfFatal(err);
                        output.unsubscribe();
                        if (!this.nl.isError(o) && !this.nl.isCompleted(o)) {
                            output.child.onError(OnErrorThrowable.addValueAsLastCause(err, this.nl.getValue(o)));
                        }
                        return;
                    }
                    ++e;
                    --r;
                    node = v;
                    if (!output.isUnsubscribed()) continue;
                    return;
                }
                if (e != 0L) {
                    output.index = node;
                    if (!unbounded) {
                        output.produced(e);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        void truncate() {
        }

        void truncateFinal() {
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next2;
            Node n = (Node)this.get();
            while ((next2 = (Node)n.get()) != null && !this.nl.isCompleted(v = this.leaveTransform(o = next2.value)) && !this.nl.isError(v)) {
                output.add(this.nl.getValue(v));
                n = next2;
            }
        }

        boolean hasError() {
            return this.tail.value != null && this.nl.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && this.nl.isCompleted(this.leaveTransform(this.tail.value));
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;
        final long index;

        public Node(Object value, long index) {
            this.value = value;
            this.index = index;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        final NotificationLite<T> nl = NotificationLite.instance();
        volatile int size;

        public UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(this.nl.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e) {
            this.add(this.nl.error(e));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(this.nl.completed());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                long r;
                int sourceIndex = this.size;
                Integer destIndexObject = (Integer)output.index();
                int destIndex = destIndexObject != null ? destIndexObject : 0;
                long r0 = r = output.get();
                long e = 0L;
                while (r != 0L && destIndex < sourceIndex) {
                    Object o = this.get(destIndex);
                    try {
                        if (this.nl.accept(output.child, o)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.unsubscribe();
                        if (!this.nl.isError(o) && !this.nl.isCompleted(o)) {
                            output.child.onError(OnErrorThrowable.addValueAsLastCause(err, this.nl.getValue(o)));
                        }
                        return;
                    }
                    if (output.isUnsubscribed()) {
                        return;
                    }
                    ++destIndex;
                    --r;
                    ++e;
                }
                if (e != 0L) {
                    output.index = destIndex;
                    if (r0 != Long.MAX_VALUE) {
                        output.produced(e);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerProducer<T> var1);
    }

    static final class InnerProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final ReplaySubscriber<T> parent;
        final Subscriber<? super T> child;
        Object index;
        final AtomicLong totalRequested;
        boolean emitting;
        boolean missed;
        static final long UNSUBSCRIBED = Long.MIN_VALUE;

        public InnerProducer(ReplaySubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.totalRequested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            if (n < 0L) {
                return;
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return;
                }
                if (r >= 0L && n == 0L) {
                    return;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.addTotalRequested(n);
            this.parent.manageRequests(this);
            this.parent.buffer.replay(this);
        }

        void addTotalRequested(long n) {
            long u;
            long r;
            do {
                if ((u = (r = this.totalRequested.get()) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.totalRequested.compareAndSet(r, u));
        }

        public long produced(long n) {
            long u;
            long r;
            if (n <= 0L) {
                throw new IllegalArgumentException("Cant produce zero or less");
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
            return u;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void unsubscribe() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.manageRequests(this);
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplaySubscriber<T>
    extends Subscriber<T>
    implements Subscription {
        final ReplayBuffer<T> buffer;
        final NotificationLite<T> nl;
        boolean done;
        static final InnerProducer[] EMPTY = new InnerProducer[0];
        static final InnerProducer[] TERMINATED = new InnerProducer[0];
        volatile boolean terminated;
        final OpenHashSet<InnerProducer<T>> producers;
        InnerProducer<T>[] producersCache;
        volatile long producersVersion;
        long producersCacheVersion;
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;
        long maxChildRequested;
        long maxUpstreamRequested;
        volatile Producer producer;
        List<InnerProducer<T>> coordinationQueue;
        boolean coordinateAll;

        public ReplaySubscriber(AtomicReference<ReplaySubscriber<T>> current, ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.nl = NotificationLite.instance();
            this.producers = new OpenHashSet();
            this.producersCache = EMPTY;
            this.shouldConnect = new AtomicBoolean();
            this.request(0L);
        }

        void init() {
            this.add(Subscriptions.create(new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call() {
                    if (!ReplaySubscriber.this.terminated) {
                        OpenHashSet openHashSet = ReplaySubscriber.this.producers;
                        synchronized (openHashSet) {
                            if (!ReplaySubscriber.this.terminated) {
                                ReplaySubscriber.this.producers.terminate();
                                ++ReplaySubscriber.this.producersVersion;
                                ReplaySubscriber.this.terminated = true;
                            }
                        }
                    }
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(InnerProducer<T> producer) {
            if (producer == null) {
                throw new NullPointerException();
            }
            if (this.terminated) {
                return false;
            }
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                if (this.terminated) {
                    return false;
                }
                this.producers.add(producer);
                ++this.producersVersion;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(InnerProducer<T> producer) {
            if (this.terminated) {
                return;
            }
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                if (this.terminated) {
                    return;
                }
                this.producers.remove(producer);
                ++this.producersVersion;
            }
        }

        @Override
        public void setProducer(Producer p) {
            Producer p0 = this.producer;
            if (p0 != null) {
                throw new IllegalStateException("Only a single producer can be set on a Subscriber.");
            }
            this.producer = p;
            this.manageRequests(null);
            this.replay();
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                this.replay();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.error(e);
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.complete();
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void manageRequests(InnerProducer<T> inner2) {
            long maxTotalRequested;
            if (this.isUnsubscribed()) {
                return;
            }
            ReplaySubscriber replaySubscriber = this;
            synchronized (replaySubscriber) {
                if (this.emitting) {
                    if (inner2 != null) {
                        List<InnerProducer<T>> q = this.coordinationQueue;
                        if (q == null) {
                            q = new ArrayList<InnerProducer<T>>();
                            this.coordinationQueue = q;
                        }
                        q.add(inner2);
                    } else {
                        this.coordinateAll = true;
                    }
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            long ri = this.maxChildRequested;
            if (inner2 != null) {
                maxTotalRequested = Math.max(ri, inner2.totalRequested.get());
            } else {
                InnerProducer<T>[] a;
                maxTotalRequested = ri;
                for (InnerProducer<T> rp : a = this.copyProducers()) {
                    if (rp == null) continue;
                    maxTotalRequested = Math.max(maxTotalRequested, rp.totalRequested.get());
                }
            }
            this.makeRequest(maxTotalRequested, ri);
            while (!this.isUnsubscribed()) {
                boolean all;
                List<InnerProducer<T>> q;
                ReplaySubscriber len$ = this;
                synchronized (len$) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                    q = this.coordinationQueue;
                    this.coordinationQueue = null;
                    all = this.coordinateAll;
                    this.coordinateAll = false;
                }
                maxTotalRequested = ri = this.maxChildRequested;
                if (q != null) {
                    for (InnerProducer<T> rp : q) {
                        maxTotalRequested = Math.max(maxTotalRequested, rp.totalRequested.get());
                    }
                }
                if (all) {
                    InnerProducer<T>[] a;
                    for (InnerProducer<T> rp : a = this.copyProducers()) {
                        if (rp == null) continue;
                        maxTotalRequested = Math.max(maxTotalRequested, rp.totalRequested.get());
                    }
                }
                this.makeRequest(maxTotalRequested, ri);
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InnerProducer<T>[] copyProducers() {
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                InnerProducer<T>[] a = this.producers.values();
                int n = a.length;
                InnerProducer[] result2 = new InnerProducer[n];
                System.arraycopy(a, 0, result2, 0, n);
                return result2;
            }
        }

        void makeRequest(long maxTotalRequests, long previousTotalRequests) {
            long ur = this.maxUpstreamRequested;
            Producer p = this.producer;
            long diff2 = maxTotalRequests - previousTotalRequests;
            if (diff2 != 0L) {
                this.maxChildRequested = maxTotalRequests;
                if (p != null) {
                    if (ur != 0L) {
                        this.maxUpstreamRequested = 0L;
                        p.request(ur + diff2);
                    } else {
                        p.request(diff2);
                    }
                } else {
                    long u = ur + diff2;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    this.maxUpstreamRequested = u;
                }
            } else if (ur != 0L && p != null) {
                this.maxUpstreamRequested = 0L;
                p.request(ur);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replay() {
            InnerProducer<T>[] pc = this.producersCache;
            if (this.producersCacheVersion != this.producersVersion) {
                OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
                synchronized (openHashSet) {
                    pc = this.producersCache;
                    InnerProducer<T>[] a = this.producers.values();
                    int n = a.length;
                    if (pc.length != n) {
                        this.producersCache = pc = new InnerProducer[n];
                    }
                    System.arraycopy(a, 0, pc, 0, n);
                    this.producersCacheVersion = this.producersVersion;
                }
            }
            ReplayBuffer<T> b = this.buffer;
            for (InnerProducer<T> rp : pc) {
                if (rp == null) continue;
                b.replay(rp);
            }
        }
    }
}

