/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class StringComboBoxModel
implements MutableComboBoxModel,
ListModel {
    public static final int BEGINS = 0;
    public static final int CONTAINS = 1;
    public static final int MATCHES = 2;
    protected int compareCriteria;
    protected List items;
    protected EventListenerList listenerList = new EventListenerList();
    protected int maxItemLength;
    protected String selectedItem;

    protected StringComboBoxModel() {
        this(new ArrayList());
    }

    public StringComboBoxModel(List items) {
        this(items, 0);
    }

    public StringComboBoxModel(String[] items) {
        this(items, 0);
    }

    public StringComboBoxModel(List items, int compareCriteria) {
        this.setItems(items);
        this.setCompareCriteria(compareCriteria);
    }

    public StringComboBoxModel(String[] items, int compareCriteria) {
        this.setItems(items);
        this.setCompareCriteria(compareCriteria);
    }

    public void addElement(Object item) {
        this.checkItemType(item);
        this.items.add(item);
        int size2 = this.items.size();
        this.fireIntervalAdded(this, size2 - 1, size2 - 1);
        if (size2 == 1 && this.selectedItem == null && item != null) {
            this.setSelectedItem(item);
        }
    }

    public void addElement(String item) {
        this.checkItemType(item);
        this.items.add(item);
        int size2 = this.items.size();
        this.fireIntervalAdded(this, size2, size2);
    }

    public void addListDataListener(ListDataListener listener) {
        this.listenerList.add(ListDataListener.class, listener);
    }

    private void checkItemType(Object item) throws ClassCastException {
        if (!(item instanceof String)) {
            throw new ClassCastException("StringComboBoxModel only support String elements.");
        }
    }

    private boolean compare(String value, String lookFor) {
        boolean result2 = false;
        if (this.compareCriteria == 0) {
            result2 = value.equals(lookFor);
        } else if (this.compareCriteria == 1) {
            result2 = value.indexOf(lookFor) != -1;
        } else if (this.compareCriteria == 2) {
            result2 = value.startsWith(lookFor);
        }
        return result2;
    }

    protected void fireContentsChanged(Object source, int index_0, int index_1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent event = null;
        for (int i = listeners.length - 2; 0 <= i; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (event == null) {
                event = new ListDataEvent(source, 0, index_0, index_1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(event);
        }
    }

    protected void fireIntervalAdded(Object source, int index_0, int index_1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent event = null;
        for (int i = listeners.length - 2; 0 <= i; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (event == null) {
                event = new ListDataEvent(source, 1, index_0, index_1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(event);
        }
    }

    protected void fireIntervalRemoved(Object source, int index_0, int index_1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent event = null;
        for (int i = listeners.length - 2; 0 <= i; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (event == null) {
                event = new ListDataEvent(source, 2, index_0, index_1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(event);
        }
    }

    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    public int getItemIndex(String lookFor) {
        return this.getItemIndex(lookFor, 0);
    }

    public int getItemIndex(String lookFor, int beginIndex) {
        int index = -1;
        if (lookFor != null) {
            boolean match = false;
            int size2 = this.items.size();
            for (index = beginIndex + 1; index < size2; ++index) {
                if (!this.compare((String)this.items.get(index), lookFor)) continue;
                match = true;
                break;
            }
            if (!match) {
                for (index = 0; index < beginIndex; ++index) {
                    if (!this.compare((String)this.items.get(index), lookFor)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                index = beginIndex;
            }
        }
        return index;
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(ListDataListener.class);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public int getMaxLength() {
        if (this.maxItemLength == 0) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.maxItemLength = Math.max(this.maxItemLength, ((String)this.items.get(i)).length());
            }
        }
        return this.maxItemLength;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public int getSize() {
        return this.items.size();
    }

    public void insertElementAt(Object item, int index) {
        this.checkItemType(item);
        this.items.add(index, item);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeAllElements() {
        if (0 < this.items.size()) {
            int beginIndex = 0;
            int endIndex = this.items.size() - 1;
            this.items.clear();
            this.selectedItem = null;
            this.fireIntervalRemoved(this, beginIndex, endIndex);
        }
    }

    public void removeElement(Object item) {
        this.checkItemType(item);
        int itemIndex = this.items.indexOf(item);
        if (itemIndex != -1) {
            this.removeElementAt(itemIndex);
        }
    }

    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedItem) {
            if (index == 0) {
                this.setSelectedItem(this.items.size() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.items.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(ListDataListener.class, listener);
    }

    public void setCompareCriteria(int compareCriteria) {
        this.compareCriteria = compareCriteria < 0 || compareCriteria > 2 ? 0 : compareCriteria;
    }

    public void setItems(List items) {
        for (int i = 0; i < items.size(); ++i) {
            this.checkItemType(items.get(i));
        }
        this.items = items;
        this.maxItemLength = 0;
        if (0 < items.size()) {
            this.fireIntervalAdded(this, 0, items.size() - 1);
        }
    }

    public void setItems(String[] strings) {
        this.items = Arrays.asList(strings);
        this.maxItemLength = 0;
        if (0 < this.items.size()) {
            this.fireIntervalAdded(this, 0, this.items.size() - 1);
        }
    }

    public void setSelectedItem(Object item) {
        this.checkItemType(item);
        if (this.selectedItem != null && !this.selectedItem.equals(item) || this.selectedItem == null && item != null) {
            this.selectedItem = (String)item;
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

