/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Notification;
import rx.Observer;
import rx.exceptions.CompositeException;

public class TestObserver<T>
implements Observer<T> {
    private final Observer<T> delegate;
    private final ArrayList<T> onNextEvents = new ArrayList();
    private final ArrayList<Throwable> onErrorEvents = new ArrayList();
    private final ArrayList<Notification<T>> onCompletedEvents = new ArrayList();
    private static Observer<Object> INERT = new Observer<Object>(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Object t) {
        }
    };

    public TestObserver(Observer<T> delegate) {
        this.delegate = delegate;
    }

    public TestObserver() {
        this.delegate = INERT;
    }

    @Override
    public void onCompleted() {
        this.onCompletedEvents.add(Notification.createOnCompleted());
        this.delegate.onCompleted();
    }

    public List<Notification<T>> getOnCompletedEvents() {
        return Collections.unmodifiableList(this.onCompletedEvents);
    }

    @Override
    public void onError(Throwable e) {
        this.onErrorEvents.add(e);
        this.delegate.onError(e);
    }

    public List<Throwable> getOnErrorEvents() {
        return Collections.unmodifiableList(this.onErrorEvents);
    }

    @Override
    public void onNext(T t) {
        this.onNextEvents.add(t);
        this.delegate.onNext(t);
    }

    public List<T> getOnNextEvents() {
        return Collections.unmodifiableList(this.onNextEvents);
    }

    public List<Object> getEvents() {
        ArrayList<ArrayList<Object>> events2 = new ArrayList<ArrayList<Object>>();
        events2.add(this.onNextEvents);
        events2.add(this.onErrorEvents);
        events2.add(this.onCompletedEvents);
        return Collections.unmodifiableList(events2);
    }

    public void assertReceivedOnNext(List<T> items) {
        if (this.onNextEvents.size() != items.size()) {
            this.assertionError("Number of items does not match. Provided: " + items.size() + "  Actual: " + this.onNextEvents.size() + ".\n" + "Provided values: " + items + "\n" + "Actual values: " + this.onNextEvents + "\n");
        }
        for (int i = 0; i < items.size(); ++i) {
            T expected = items.get(i);
            T actual = this.onNextEvents.get(i);
            if (expected == null) {
                if (actual == null) continue;
                this.assertionError("Value at index: " + i + " expected to be [null] but was: [" + actual + "]\n");
                continue;
            }
            if (expected.equals(actual)) continue;
            this.assertionError("Value at index: " + i + " expected to be [" + expected + "] (" + expected.getClass().getSimpleName() + ") but was: [" + actual + "] (" + (actual != null ? actual.getClass().getSimpleName() : "null") + ")\n");
        }
    }

    public void assertTerminalEvent() {
        if (this.onErrorEvents.size() > 1) {
            this.assertionError("Too many onError events: " + this.onErrorEvents.size());
        }
        if (this.onCompletedEvents.size() > 1) {
            this.assertionError("Too many onCompleted events: " + this.onCompletedEvents.size());
        }
        if (this.onCompletedEvents.size() == 1 && this.onErrorEvents.size() == 1) {
            this.assertionError("Received both an onError and onCompleted. Should be one or the other.");
        }
        if (this.onCompletedEvents.size() == 0 && this.onErrorEvents.size() == 0) {
            this.assertionError("No terminal events received.");
        }
    }

    final void assertionError(String message) {
        StringBuilder b = new StringBuilder(message.length() + 32);
        b.append(message);
        b.append(" (");
        int c = this.onCompletedEvents.size();
        b.append(c);
        b.append(" completion");
        if (c != 1) {
            b.append("s");
        }
        b.append(")");
        if (!this.onErrorEvents.isEmpty()) {
            int size2 = this.onErrorEvents.size();
            b.append(" (+").append(size2).append(" error");
            if (size2 != 1) {
                b.append("s");
            }
            b.append(")");
        }
        AssertionError ae = new AssertionError((Object)b.toString());
        if (!this.onErrorEvents.isEmpty()) {
            if (this.onErrorEvents.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.onErrorEvents.get(0));
            } else {
                ((Throwable)((Object)ae)).initCause(new CompositeException(this.onErrorEvents));
            }
        }
        throw ae;
    }
}

