/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.unsafe;

import java.lang.reflect.Field;
import java.util.Iterator;
import rx.internal.util.unsafe.Pow2;
import rx.internal.util.unsafe.QueueProgressIndicators;
import rx.internal.util.unsafe.SpscUnboundedArrayQueueConsumerField;
import rx.internal.util.unsafe.SpscUnboundedArrayQueueProducerFields;
import rx.internal.util.unsafe.UnsafeAccess;

public class SpscUnboundedArrayQueue<E>
extends SpscUnboundedArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    static final int MAX_LOOK_AHEAD_STEP;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;
    private static final Object HAS_NEXT;

    public SpscUnboundedArrayQueue(int bufferSize) {
        int p2capacity = Pow2.roundToPowerOfTwo(bufferSize);
        long mask = p2capacity - 1;
        Object[] buffer = new Object[p2capacity + 1];
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2capacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLookAhead = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.producerBuffer;
        long index = this.producerIndex;
        long mask = this.producerMask;
        long offset = SpscUnboundedArrayQueue.calcWrappedOffset(index, mask);
        if (index < this.producerLookAhead) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        int lookAheadStep = this.producerLookAheadStep;
        long lookAheadElementOffset = SpscUnboundedArrayQueue.calcWrappedOffset(index + (long)lookAheadStep, mask);
        if (null == SpscUnboundedArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLookAhead = index + (long)lookAheadStep - 1L;
            return this.writeToQueue(buffer, e, index, offset);
        }
        if (null != SpscUnboundedArrayQueue.lvElement(buffer, SpscUnboundedArrayQueue.calcWrappedOffset(index + 1L, mask))) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        this.resize(buffer, index, offset, e, mask);
        return true;
    }

    private boolean writeToQueue(E[] buffer, E e, long index, long offset) {
        SpscUnboundedArrayQueue.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    private void resize(E[] oldBuffer, long currIndex, long offset, E e, long mask) {
        int capacity = oldBuffer.length;
        Object[] newBuffer = new Object[capacity];
        this.producerBuffer = newBuffer;
        this.producerLookAhead = currIndex + mask - 1L;
        SpscUnboundedArrayQueue.soElement(newBuffer, offset, e);
        this.soNext(oldBuffer, newBuffer);
        SpscUnboundedArrayQueue.soElement(oldBuffer, offset, HAS_NEXT);
        this.soProducerIndex(currIndex + 1L);
    }

    private void soNext(E[] curr, E[] next2) {
        SpscUnboundedArrayQueue.soElement(curr, SpscUnboundedArrayQueue.calcDirectOffset(curr.length - 1), next2);
    }

    private E[] lvNext(E[] curr) {
        return (Object[])SpscUnboundedArrayQueue.lvElement(curr, SpscUnboundedArrayQueue.calcDirectOffset(curr.length - 1));
    }

    @Override
    public final E poll() {
        boolean isNextBuffer;
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = SpscUnboundedArrayQueue.calcWrappedOffset(index, mask);
        Object e = SpscUnboundedArrayQueue.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == HAS_NEXT;
        if (null != e && !isNextBuffer) {
            SpscUnboundedArrayQueue.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            return (E)e;
        }
        if (isNextBuffer) {
            return (E)this.newBufferPoll(this.lvNext(buffer), index, mask);
        }
        return null;
    }

    private E newBufferPoll(E[] nextBuffer, long index, long mask) {
        this.consumerBuffer = nextBuffer;
        long offsetInNew = SpscUnboundedArrayQueue.calcWrappedOffset(index, mask);
        Object n = SpscUnboundedArrayQueue.lvElement(nextBuffer, offsetInNew);
        if (null == n) {
            return null;
        }
        SpscUnboundedArrayQueue.soElement(nextBuffer, offsetInNew, null);
        this.soConsumerIndex(index + 1L);
        return (E)n;
    }

    @Override
    public final E peek() {
        Object[] buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        long offset = SpscUnboundedArrayQueue.calcWrappedOffset(index, mask);
        Object e = SpscUnboundedArrayQueue.lvElement(buffer, offset);
        if (e == HAS_NEXT) {
            return (E)this.newBufferPeek(this.lvNext(buffer), index, mask);
        }
        return (E)e;
    }

    private E newBufferPeek(E[] nextBuffer, long index, long mask) {
        this.consumerBuffer = nextBuffer;
        long offsetInNew = SpscUnboundedArrayQueue.calcWrappedOffset(index, mask);
        return (E)SpscUnboundedArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private static long calcWrappedOffset(long index, long mask) {
        return SpscUnboundedArrayQueue.calcDirectOffset(index & mask);
    }

    private static long calcDirectOffset(long index) {
        return REF_ARRAY_BASE + (index << REF_ELEMENT_SHIFT);
    }

    private static void soElement(Object[] buffer, long offset, Object e) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
    }

    private static <E> Object lvElement(E[] buffer, long offset) {
        return UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    static {
        Field iField;
        MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
        HAS_NEXT = new Object();
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
        try {
            iField = SpscUnboundedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            iField = SpscUnboundedArrayQueueConsumerField.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(iField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

