/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.schedulers.SchedulerLifecycle;
import rx.internal.util.RxThreadFactory;

public final class GenericScheduledExecutorService
implements SchedulerLifecycle {
    private static final String THREAD_NAME_PREFIX = "RxScheduledExecutorPool-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("RxScheduledExecutorPool-");
    private static final ScheduledExecutorService[] NONE = new ScheduledExecutorService[0];
    private static final ScheduledExecutorService SHUTDOWN = Executors.newScheduledThreadPool(0);
    public static final GenericScheduledExecutorService INSTANCE;
    private final AtomicReference<ScheduledExecutorService[]> executor = new AtomicReference<ScheduledExecutorService[]>(NONE);
    private static int roundRobin;

    private GenericScheduledExecutorService() {
        this.start();
    }

    @Override
    public void start() {
        int count2 = Runtime.getRuntime().availableProcessors();
        if (count2 > 4) {
            count2 /= 2;
        }
        if (count2 > 8) {
            count2 = 8;
        }
        ScheduledExecutorService[] execs = new ScheduledExecutorService[count2];
        for (int i = 0; i < count2; ++i) {
            execs[i] = Executors.newScheduledThreadPool(1, THREAD_FACTORY);
        }
        if (this.executor.compareAndSet(NONE, execs)) {
            for (ScheduledExecutorService exec2 : execs) {
                if (NewThreadWorker.tryEnableCancelPolicy(exec2) || !(exec2 instanceof ScheduledThreadPoolExecutor)) continue;
                NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)exec2);
            }
        } else {
            for (ScheduledExecutorService exec3 : execs) {
                exec3.shutdownNow();
            }
        }
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService[] execs;
        do {
            if ((execs = this.executor.get()) != NONE) continue;
            return;
        } while (!this.executor.compareAndSet(execs, NONE));
        for (ScheduledExecutorService exec2 : execs) {
            NewThreadWorker.deregisterExecutor(exec2);
            exec2.shutdownNow();
        }
    }

    public static ScheduledExecutorService getInstance() {
        ScheduledExecutorService[] execs = GenericScheduledExecutorService.INSTANCE.executor.get();
        if (execs == NONE) {
            return SHUTDOWN;
        }
        int r = roundRobin + 1;
        if (r >= execs.length) {
            r = 0;
        }
        roundRobin = r;
        return execs[r];
    }

    static {
        SHUTDOWN.shutdown();
        INSTANCE = new GenericScheduledExecutorService();
    }
}

