/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Completable;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeTimeout
implements Completable.CompletableOnSubscribe {
    final Completable source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Completable other;

    public CompletableOnSubscribeTimeout(Completable source, long timeout2, TimeUnit unit, Scheduler scheduler, Completable other) {
        this.source = source;
        this.timeout = timeout2;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void call(final Completable.CompletableSubscriber s2) {
        final CompositeSubscription set = new CompositeSubscription();
        s2.onSubscribe(set);
        final AtomicBoolean once = new AtomicBoolean();
        Scheduler.Worker w = this.scheduler.createWorker();
        set.add(w);
        w.schedule(new Action0(){

            @Override
            public void call() {
                if (once.compareAndSet(false, true)) {
                    set.clear();
                    if (CompletableOnSubscribeTimeout.this.other == null) {
                        s2.onError(new TimeoutException());
                    } else {
                        CompletableOnSubscribeTimeout.this.other.unsafeSubscribe(new Completable.CompletableSubscriber(){

                            @Override
                            public void onSubscribe(Subscription d) {
                                set.add(d);
                            }

                            @Override
                            public void onError(Throwable e) {
                                set.unsubscribe();
                                s2.onError(e);
                            }

                            @Override
                            public void onCompleted() {
                                set.unsubscribe();
                                s2.onCompleted();
                            }
                        });
                    }
                }
            }
        }, this.timeout, this.unit);
        this.source.unsafeSubscribe(new Completable.CompletableSubscriber(){

            @Override
            public void onSubscribe(Subscription d) {
                set.add(d);
            }

            @Override
            public void onError(Throwable e) {
                if (once.compareAndSet(false, true)) {
                    set.unsubscribe();
                    s2.onError(e);
                } else {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                }
            }

            @Override
            public void onCompleted() {
                if (once.compareAndSet(false, true)) {
                    set.unsubscribe();
                    s2.onCompleted();
                }
            }
        });
    }
}

