/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class BufferUntilSubscriber<T>
extends Subject<T, T> {
    final State<T> state;
    private boolean forward = false;
    static final Observer EMPTY_OBSERVER = new Observer(){

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        public void onNext(Object t) {
        }
    };

    public static <T> BufferUntilSubscriber<T> create() {
        State state = new State();
        return new BufferUntilSubscriber(state);
    }

    private BufferUntilSubscriber(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(Object v) {
        Object object = this.state.guard;
        synchronized (object) {
            this.state.buffer.add(v);
            if (this.state.get() != null && !this.state.emitting) {
                this.forward = true;
                this.state.emitting = true;
            }
        }
        if (this.forward) {
            Object o;
            while ((o = this.state.buffer.poll()) != null) {
                this.state.nl.accept((Observer)this.state.get(), o);
            }
        }
    }

    @Override
    public void onCompleted() {
        if (this.forward) {
            ((Observer)this.state.get()).onCompleted();
        } else {
            this.emit(this.state.nl.completed());
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.forward) {
            ((Observer)this.state.get()).onError(e);
        } else {
            this.emit(this.state.nl.error(e));
        }
    }

    @Override
    public void onNext(T t) {
        if (this.forward) {
            ((Observer)this.state.get()).onNext(t);
        } else {
            this.emit(this.state.nl.next(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasObservers() {
        Object object = this.state.guard;
        synchronized (object) {
            return this.state.get() != null;
        }
    }

    static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(Subscriber<? super T> s2) {
            if (this.state.casObserverRef(null, s2)) {
                s2.add(Subscriptions.create(new Action0(){

                    @Override
                    public void call() {
                        OnSubscribeAction.this.state.set(EMPTY_OBSERVER);
                    }
                }));
                boolean win = false;
                Object object = this.state.guard;
                synchronized (object) {
                    if (!this.state.emitting) {
                        this.state.emitting = true;
                        win = true;
                    }
                }
                if (win) {
                    NotificationLite nl = NotificationLite.instance();
                    while (true) {
                        Object o;
                        if ((o = this.state.buffer.poll()) != null) {
                            nl.accept((Observer)this.state.get(), o);
                            continue;
                        }
                        Object object2 = this.state.guard;
                        synchronized (object2) {
                            if (this.state.buffer.isEmpty()) {
                                this.state.emitting = false;
                                break;
                            }
                        }
                    }
                }
            } else {
                s2.onError(new IllegalStateException("Only one subscriber allowed!"));
            }
        }
    }

    static final class State<T>
    extends AtomicReference<Observer<? super T>> {
        private static final long serialVersionUID = 8026705089538090368L;
        final Object guard = new Object();
        boolean emitting = false;
        final ConcurrentLinkedQueue<Object> buffer = new ConcurrentLinkedQueue();
        final NotificationLite<T> nl = NotificationLite.instance();

        State() {
        }

        boolean casObserverRef(Observer<? super T> expected, Observer<? super T> next2) {
            return this.compareAndSet(expected, next2);
        }
    }
}

