/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

public class NumberUtilities {
    private NumberUtilities() {
    }

    private static final byte[] reverseOrder(byte[] si, int i) {
        byte[] is = new byte[i];
        for (int b = 0; b <= i - 1; b = (int)((byte)(b + 1))) {
            is[b] = si[i - 1 - b];
        }
        return is;
    }

    public static final byte[] toByteArray(char c) {
        return NumberUtilities.toByteArray(c, false);
    }

    public static final byte[] toByteArray(double d) {
        return NumberUtilities.toByteArray(d, false);
    }

    public static final byte[] toByteArray(float f) {
        return NumberUtilities.toByteArray(f, false);
    }

    public static final byte[] toByteArray(int i) {
        return NumberUtilities.toByteArray(i, false);
    }

    public static final byte[] toByteArray(long l) {
        return NumberUtilities.toByteArray(l, false);
    }

    public static final byte[] toByteArray(short i) {
        return NumberUtilities.toByteArray(i, false);
    }

    public static final byte[] toByteArray(char c, boolean isReverseOrder) {
        byte[] si = new byte[2];
        for (int i = 0; i <= 1; i = (int)((byte)(i + 1))) {
            si[i] = (byte)(c >>> (1 - i) * 8);
        }
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 2);
        }
        return si;
    }

    public static final byte[] toByteArray(double d, boolean isReverseOrder) {
        byte[] si = new byte[8];
        long l = Double.doubleToLongBits(d);
        si = NumberUtilities.toByteArray(l, isReverseOrder);
        return si;
    }

    public static final byte[] toByteArray(float f, boolean isReverseOrder) {
        byte[] si = new byte[4];
        int i = Float.floatToIntBits(f);
        si = NumberUtilities.toByteArray(i, isReverseOrder);
        return si;
    }

    public static final byte[] toByteArray(int i, boolean isReverseOrder) {
        byte[] si = new byte[4];
        for (int b = 0; b <= 3; b = (int)((byte)(b + 1))) {
            si[b] = (byte)(i >>> (3 - b) * 8);
        }
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 4);
        }
        return si;
    }

    public static final byte[] toByteArray(long l, boolean isReverseOrder) {
        byte[] si = new byte[8];
        for (int i = 0; i <= 7; i = (int)((byte)(i + 1))) {
            si[i] = (byte)(l >>> (7 - i) * 8);
        }
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 8);
        }
        return si;
    }

    public static final byte[] toByteArray(short i, boolean isReverseOrder) {
        byte[] si = new byte[2];
        for (int b = 0; b <= 1; b = (int)((byte)(b + 1))) {
            si[b] = (byte)(i >>> (1 - b) * 8);
        }
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 2);
        }
        return si;
    }

    public static final char toChar(byte[] si) {
        return NumberUtilities.toChar(si, false);
    }

    public static final char toChar(byte[] si, boolean isReverseOrder) {
        char i = '\u0000';
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 2);
        }
        char c = (char)((i | (char)si[0]) << 8);
        c = (char)(c | (char)si[1]);
        return c;
    }

    public static final double toDouble(byte[] si) {
        return NumberUtilities.toDouble(si, false);
    }

    public static final double toDouble(byte[] si, boolean isReverseOrder) {
        double d = 0.0;
        long l = NumberUtilities.toLong(si, isReverseOrder);
        d = Double.longBitsToDouble(l);
        return d;
    }

    public static final float toFloat(byte[] si) {
        return NumberUtilities.toFloat(si, false);
    }

    public static final float toFloat(byte[] si, boolean isReverseOrder) {
        float f = 0.0f;
        int i = NumberUtilities.toInt(si, isReverseOrder);
        f = Float.intBitsToFloat(i);
        return f;
    }

    public static final int toInt(byte[] si) {
        return NumberUtilities.toInt(si, false);
    }

    public static final int toInt(byte[] si, boolean isReverseOrder) {
        int i = 0;
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 4);
        }
        int nb = si.length - 1;
        for (int b = 0; b <= nb; b = (int)((byte)(b + 1))) {
            int j;
            if (si[b] < 0) {
                si[b] = (byte)(si[b] & 0x7F);
                j = si[b];
                j |= 0x80;
            } else {
                j = si[b];
            }
            i |= j;
            if (b >= nb) continue;
            i <<= 8;
        }
        return i;
    }

    public static final long toLong(byte[] si) {
        return NumberUtilities.toLong(si, false);
    }

    public static final long toLong(byte[] si, boolean isReverseOrder) {
        long l = 0L;
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 8);
        }
        int nb = si.length - 1;
        for (int i = 0; i <= nb; i = (int)((byte)(i + 1))) {
            long j;
            if (si[i] < 0) {
                si[i] = (byte)(si[i] & 0x7F);
                j = si[i];
                j |= 0x80L;
            } else {
                j = si[i];
            }
            l |= j;
            if (i >= nb) continue;
            l <<= 8;
        }
        return l;
    }

    public static final short toShort(byte[] si) {
        return NumberUtilities.toShort(si, false);
    }

    public static final short toShort(byte[] si, boolean isReverseOrder) {
        short i = 0;
        if (isReverseOrder) {
            si = NumberUtilities.reverseOrder(si, 2);
        }
        for (int b = 0; b <= 1; b = (int)((byte)(b + 1))) {
            short j;
            if (si[b] < 0) {
                si[b] = (byte)(si[b] & 0x7F);
                j = si[b];
                j = (short)(j | 0x80);
            } else {
                j = si[b];
            }
            i = (short)(i | j);
            if (b >= 1) continue;
            i = (short)(i << 8);
        }
        return i;
    }

    public static int unsignedBytetoInt(byte b) {
        return b & 0xFF;
    }

    public static String toHexString(byte[] b) {
        if (b == null) {
            return "null";
        }
        StringBuffer ret = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(256 + (b[i] & 0xFF)).substring(1);
            ret.append((hex.length() < 2 ? "0" : "") + hex);
        }
        return ret.toString();
    }
}

