/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.mbari.swing.ListListModel;

public class ListTableCellRenderer
extends JList
implements TableCellRenderer {
    private static final long serialVersionUID = 6278328970815317715L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private WeakHashMap map = new WeakHashMap();
    private Color unselectedBackground;
    private Color unselectedForeground;

    public ListTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(value);
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    protected void setValue(Object value) {
        Object listModel = this.map.get(value);
        if (listModel == null) {
            listModel = new ListListModel((List)value);
            this.map.put(value, listModel);
        }
        this.setModel((ListModel)listModel);
    }
}

