/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.mbari.swing.JFancyButton;
import org.mbari.swing.SwingUtils;

public class SearchableTreePanel
extends JPanel {
    private static boolean resetEnum = false;
    private static Enumeration enm;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private JButton searchBtn = null;
    private JPanel searchButtonPanel = null;
    private JPanel searchPanel = null;
    private JTextField searchTextField = null;
    private char[] wordSeparators = new char[]{' ', '\t', '-', '_'};
    private JCheckBox globCheckBox;

    public SearchableTreePanel() {
        this.initialize();
    }

    private JCheckBox getGlobCheckBox() {
        if (this.globCheckBox == null) {
            this.globCheckBox = new JCheckBox();
            this.globCheckBox.setText("Glob");
            this.globCheckBox.setMargin(new Insets(0, 4, 0, 4));
        }
        return this.globCheckBox;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    public JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
        }
        return this.jTree;
    }

    public String getNodeTextToSearch(DefaultMutableTreeNode node) {
        return node.toString();
    }

    protected JButton getSearchBtn() {
        if (this.searchBtn == null) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/view.png"));
            this.searchBtn = new JFancyButton();
            this.searchBtn.setIcon(icon);
            this.searchBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/images/view_next.png")));
            this.searchBtn.setName("searchBtn");
            this.searchBtn.setToolTipText("Search for words in the tree, use this button or press enter in search field");
            this.searchBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!SearchableTreePanel.this.goToMatchingNode(SearchableTreePanel.this.getSearchTextField().getText().toLowerCase())) {
                        SwingUtils.flashJComponent(SearchableTreePanel.this.getSearchTextField(), 5);
                    }
                }
            });
            this.searchBtn.setEnabled(false);
        }
        return this.searchBtn;
    }

    private JPanel getSearchButtonPanel() {
        if (this.searchButtonPanel == null) {
            this.searchButtonPanel = new JPanel();
            this.searchButtonPanel.setLayout(new BorderLayout());
            this.searchButtonPanel.add((Component)this.getSearchBtn(), "Center");
            this.searchButtonPanel.add((Component)this.getGlobCheckBox(), "West");
        }
        return this.searchButtonPanel;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel();
            this.searchPanel.setLayout(new BorderLayout());
            this.searchPanel.setBorder(BorderFactory.createTitledBorder(null, "Search", 0, 0, null, null));
            this.searchPanel.add((Component)this.getSearchButtonPanel(), "East");
            this.searchPanel.add((Component)this.getSearchTextField(), "Center");
            this.searchPanel.setName("search");
            this.searchPanel.setToolTipText("Search for next matching item in tree");
        }
        return this.searchPanel;
    }

    protected JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setColumns(15);
            this.searchTextField.setText("");
            this.searchTextField.setToolTipText("Search for words in tree, press enter to search, or press search button");
            this.searchTextField.putClientProperty("JTextField.variant", "search");
            this.searchTextField.putClientProperty("JTextField.Search.Prompt", "Search");
            this.searchTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!SearchableTreePanel.this.goToMatchingNode(SearchableTreePanel.this.getSearchTextField().getText().toLowerCase())) {
                        SwingUtils.flashJComponent(SearchableTreePanel.this.getSearchTextField(), 4);
                    }
                }
            });
            this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    String text = SearchableTreePanel.this.searchTextField.getText();
                    SearchableTreePanel.this.getSearchBtn().setEnabled(text != null && text.length() > 0 && !text.matches("\\A\\s+"));
                }
            });
        }
        return this.searchTextField;
    }

    public char[] getWordSeparators() {
        return this.wordSeparators;
    }

    public boolean goToMatchingNode(String text, boolean useGlobSearch) {
        SearchType searchType = useGlobSearch ? SearchType.GLOB : SearchType.LEADING;
        return this.goToMatchingNode(text, searchType);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean goToMatchingNode(String text, SearchType searchType) {
        text = text.toLowerCase();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getJTree().getModel().getRoot();
        if (enm == null) {
            enm = root.preorderEnumeration();
            resetEnum = true;
        } else {
            resetEnum = false;
        }
        DefaultMutableTreeNode nodeFound = null;
        block5: while (enm.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enm.nextElement();
            String nodeName = this.getNodeTextToSearch(node).toLowerCase();
            switch (searchType) {
                case EXACT: {
                    if (!nodeName.equals(text)) break;
                    nodeFound = node;
                    break;
                }
                case GLOB: {
                    if (nodeName.indexOf(text) == -1) break;
                    nodeFound = node;
                    break block5;
                }
                case LEADING: {
                    String[] parts;
                    for (String p : parts = nodeName.split(" ")) {
                        if (!p.startsWith(text)) continue;
                        nodeFound = node;
                        break block5;
                    }
                }
            }
        }
        if (nodeFound != null) {
            TreePath path = new TreePath(nodeFound.getPath());
            this.getJTree().setSelectionPath(path);
            this.getJTree().scrollPathToVisible(path);
            return true;
        }
        if (!resetEnum) {
            enm = null;
            return this.goToMatchingNode(text, searchType);
        }
        return false;
    }

    boolean goToMatchingNode(String text) {
        return this.goToMatchingNode(text, this.isGlobSearch());
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSearchPanel(), "North");
        this.add((Component)this.getJScrollPane(), "Center");
        this.setSize(261, 329);
    }

    public boolean isGlobSearch() {
        return this.getGlobCheckBox().isSelected();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Searchable Tree");
        frame.getContentPane().add(new SearchableTreePanel());
        frame.setDefaultCloseOperation(3);
        frame.setBounds(300, 300, 300, 300);
        frame.setVisible(true);
    }

    public void setGlobSearch(boolean b) {
        this.getGlobCheckBox().setSelected(b);
    }

    public void setJTree(JTree tree) {
        this.remove(this.getJTree());
        this.jTree = tree;
        this.getJScrollPane().setViewportView(this.jTree);
    }

    public void setWordSeparators(char[] cs) {
        this.wordSeparators = cs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        LEADING,
        GLOB,
        EXACT;

    }
}

