/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

public class ListListModel
extends AbstractListModel
implements List,
Serializable {
    private static final long serialVersionUID = -5606745348920993367L;
    protected List delegate;

    public ListListModel(List list) {
        this.delegate = list;
    }

    public boolean add(Object obj) {
        int index = this.delegate.size();
        boolean rv = this.delegate.add(obj);
        this.fireIntervalAdded(this, index, index);
        return rv;
    }

    public void add(int index, Object element) {
        this.delegate.add(index, element);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean addAll(Collection c) {
        int delegateSize = this.delegate.size();
        boolean changed = this.delegate.addAll(c);
        if (changed) {
            int newSize = delegateSize + c.size() - 1;
            this.fireIntervalAdded(this, delegateSize, newSize);
        }
        return changed;
    }

    public boolean addAll(int index, Collection c) {
        return this.delegate.addAll(index, c);
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public boolean contains(Object elem) {
        return this.delegate.contains(elem);
    }

    public boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public Object elementAt(int index) {
        return this.delegate.get(index);
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public Object getElementAt(int index) {
        return this.delegate.get(index);
    }

    public List getList() {
        return this.delegate;
    }

    public int getSize() {
        try {
            return this.delegate.size();
        }
        catch (NullPointerException npe) {
            System.out.println("Error: Can't get valid list size");
            return 0;
        }
    }

    public int indexOf(Object elem) {
        return this.delegate.indexOf(elem);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return this.delegate.iterator();
    }

    public int lastIndexOf(Object elem) {
        return this.delegate.lastIndexOf(elem);
    }

    public ListIterator listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    public void refreshView() {
        this.fireContentsChanged(this, 0, this.size() - 1);
    }

    public Object remove(int index) {
        Object obj = this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return obj;
    }

    public boolean remove(Object obj) {
        int index = this.delegate.indexOf(obj);
        boolean rv = this.delegate.remove(obj);
        this.fireIntervalRemoved(this, index, index);
        return rv;
    }

    public boolean removeAll(Collection c) {
        return this.delegate.removeAll(c);
    }

    public void removeRange(int fromIndex, int toIndex) {
        for (int i = toIndex; i >= fromIndex; --i) {
            this.delegate.remove(i);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    public boolean retainAll(Collection c) {
        return this.delegate.retainAll(c);
    }

    public Object set(int index, Object element) {
        Object rv = this.delegate.get(index);
        this.delegate.set(index, element);
        this.fireContentsChanged(this, index, index);
        return rv;
    }

    public void setElementAt(int index, Object obj) {
        this.delegate.set(index, obj);
        this.fireContentsChanged(this, index, index);
    }

    public void setList(List list) {
        int indexOld = this.delegate.size() - 1;
        int indexNew = list.size() - 1;
        this.delegate = list;
        this.fireIntervalRemoved(this, 0, indexOld);
        this.fireIntervalAdded(this, 0, indexNew);
    }

    public int size() {
        return this.delegate.size();
    }

    public List subList(int i, int j) {
        return this.delegate.subList(i, j);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

