/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.mbari.io.IOUtilities;

public class URLUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, File file) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IOUtilities.copy(inputStream, outputStream);
        }
        finally {
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
        }
    }

    public static File urlToTempFile(URL url) throws IOException {
        String externalForm = url.toExternalForm();
        String[] pathParts = externalForm.split("/");
        String name = pathParts[pathParts.length - 1];
        String[] nameParts = name.split("\\.");
        String ext = nameParts[nameParts.length - 1];
        if (nameParts.length <= 1) {
            ext = "";
        }
        return File.createTempFile("temp", ext);
    }

    public static File copyToTempFile(URL url) throws IOException {
        File tmpFile = URLUtilities.urlToTempFile(url);
        URLUtilities.copy(url, tmpFile);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] byteArray = null;
        try {
            IOUtilities.copy(in, bo);
            byteArray = bo.toByteArray();
        }
        finally {
            bo.close();
        }
        return byteArray;
    }

    public static File toFile(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }
}

