/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class AsciiHexReader
extends FilterReader
implements DataInput {
    public AsciiHexReader(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        int ch2;
        Reader in = this.in;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        ch1 = Character.digit((char)ch1, 16);
        ch2 = Character.digit((char)ch2, 16);
        return (ch1 << 4) + (ch2 << 0);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        return (byte)ch;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        return ch;
    }

    public short readShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch1 = this.read();
        return (char)ch1;
    }

    public int readInt() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        return null;
    }

    public String readUTF() throws IOException {
        return null;
    }

    public final int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }
}

