/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.geometry;

import java.awt.geom.Rectangle2D;
import org.mbari.geometry.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Envelope<T extends Number> {
    private final Point2D<T> corner0;
    private final Point2D<T> corner1;
    private Point2D<T> maximum;
    private Point2D<T> minimum;

    public Envelope(Point2D<T> corner0, Point2D<T> corner1) {
        this.corner0 = corner0;
        this.corner1 = corner1;
        this.calculate();
    }

    public Envelope(T x0, T y0, T x1, T y1) {
        this(new Point2D<T>(x0, y0), new Point2D<T>(x1, y1));
    }

    private void calculate() {
        T maxY;
        T minY;
        T maxX;
        T minX;
        if (((Number)this.corner0.getX()).doubleValue() < ((Number)this.corner1.getX()).doubleValue()) {
            minX = this.corner0.getX();
            maxX = this.corner1.getX();
        } else {
            minX = this.corner1.getX();
            maxX = this.corner0.getX();
        }
        if (((Number)this.corner0.getY()).doubleValue() < ((Number)this.corner1.getY()).doubleValue()) {
            minY = this.corner0.getY();
            maxY = this.corner1.getY();
        } else {
            minY = this.corner1.getY();
            maxY = this.corner0.getY();
        }
        this.minimum = new Point2D<T>(minX, minY);
        this.maximum = new Point2D<T>(maxX, maxY);
    }

    public boolean contains(Point2D<T> p) {
        double minX = ((Number)this.minimum.getX()).doubleValue();
        double maxX = ((Number)this.maximum.getX()).doubleValue();
        double minY = ((Number)this.minimum.getY()).doubleValue();
        double maxY = ((Number)this.maximum.getY()).doubleValue();
        double x = ((Number)p.getX()).doubleValue();
        double y = ((Number)p.getY()).doubleValue();
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public double getWidth() {
        return ((Number)this.getMaximum().getX()).doubleValue() - ((Number)this.getMinimum().getX()).doubleValue();
    }

    public double getHeight() {
        return ((Number)this.getMaximum().getY()).doubleValue() - ((Number)this.getMinimum().getY()).doubleValue();
    }

    public Point2D<T> getCorner0() {
        return this.corner0;
    }

    public Point2D<T> getCorner1() {
        return this.corner1;
    }

    public Point2D<T> getMaximum() {
        return this.maximum;
    }

    public Point2D<T> getMinimum() {
        return this.minimum;
    }

    public Rectangle2D asRectangle() {
        return new Rectangle2D.Double(((Number)this.getMinimum().getX()).doubleValue(), ((Number)this.getMinimum().getY()).doubleValue(), this.getWidth(), this.getHeight());
    }
}

