/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.mbari.smith.tiffresize.FileInfo;
import org.mbari.smith.tiffresize.FileInfo$;
import org.mbari.smith.tiffresize.JpegWriter$;
import org.mbari.smith.tiffresize.TiffReader$;
import rx.lang.scala.Subject;
import rx.lang.scala.Subject$;
import rx.lang.scala.schedulers.ComputationScheduler;
import rx.lang.scala.schedulers.ComputationScheduler$;
import rx.lang.scala.schedulers.ExecutionContextScheduler;
import rx.lang.scala.schedulers.ExecutionContextScheduler$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class MainRxPar$ {
    public static final MainRxPar$ MODULE$;
    private final Subject<FileInfo> readSubject;
    private final Subject<FileInfo> resizeSubject;
    private final Subject<FileInfo> writeSubject;
    private final AtomicInteger completedCount;

    static {
        new MainRxPar$();
    }

    public Subject<FileInfo> readSubject() {
        return this.readSubject;
    }

    public Subject<FileInfo> resizeSubject() {
        return this.resizeSubject;
    }

    public Subject<FileInfo> writeSubject() {
        return this.writeSubject;
    }

    public AtomicInteger completedCount() {
        return this.completedCount;
    }

    public void main(String[] args) {
        File src = new File(args[0]);
        File target = new File(args[1]);
        if (src.isDirectory()) {
            List<FileInfo> files = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])src.listFiles()).filter(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File f) {
                    return Functions$.MODULE$.isTiff(f);
                }
            })).sortBy(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$1) {
                    return x$1.getAbsoluteFile().getName();
                }
            }, Ordering$String$.MODULE$)).map(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final FileInfo apply(File x$2) {
                    return new FileInfo(x$2, 0, FileInfo$.MODULE$.apply$default$3());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileInfo.class)))).toList();
            Serializable serializable = target.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean(target.mkdirs());
            ExecutionContextScheduler ioIn = ExecutionContextScheduler$.MODULE$.apply(ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(1)));
            ExecutionContextScheduler ioOut = ExecutionContextScheduler$.MODULE$.apply(ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(2)));
            ComputationScheduler compute2 = ComputationScheduler$.MODULE$.apply();
            this.readSubject().onBackpressureBuffer().observeOn(ioIn).foreach((Function1<FileInfo, BoxedUnit>)((Object)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(FileInfo f) {
                    MainRxPar$.MODULE$.read(f, MainRxPar$.MODULE$.readSubject(), MainRxPar$.MODULE$.resizeSubject());
                }
            }));
            this.resizeSubject().observeOn(compute2).foreach((Function1<FileInfo, BoxedUnit>)((Object)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(FileInfo f) {
                    MainRxPar$.MODULE$.resize(f, MainRxPar$.MODULE$.readSubject(), MainRxPar$.MODULE$.writeSubject());
                }
            }));
            this.writeSubject().observeOn(ioOut).foreach((Function1<FileInfo, BoxedUnit>)((Object)new scala.Serializable(target){
                public static final long serialVersionUID = 0L;
                private final File target$1;

                public final void apply(FileInfo f) {
                    MainRxPar$.MODULE$.write(f, this.target$1, MainRxPar$.MODULE$.readSubject());
                }
                {
                    this.target$1 = target$1;
                }
            }));
            files.foreach(new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(FileInfo f) {
                    MainRxPar$.MODULE$.readSubject().onNext(f);
                }
            });
            boolean ok = true;
            while (ok) {
                Thread.sleep(100L);
                if (this.completedCount().get() != files.size()) continue;
                ok = false;
            }
        }
    }

    public void retry(FileInfo fi, Subject<FileInfo> readSubject, String msg) {
        if (fi.count() < 4) {
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " FAILED! Trying again later."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
            readSubject.onNext(fi.increment());
        } else {
            this.completedCount().getAndIncrement();
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " FAILED!!. We tried 5 times. We're giving up!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
        }
    }

    public void read(FileInfo fi, Subject<FileInfo> readSubject, Subject<FileInfo> computeSubject) {
        String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Reading ", " ..."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{Thread.currentThread().getName(), fi.file()}));
        try {
            BufferedImage img = TiffReader$.MODULE$.apply(fi.file().getAbsolutePath());
            Some<BufferedImage> x$3 = new Some<BufferedImage>(img);
            File x$4 = fi.copy$default$1();
            int x$5 = fi.copy$default$2();
            FileInfo fiWithImg = fi.copy(x$4, x$5, x$3);
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " SUCCESS!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
            computeSubject.onNext(fiWithImg);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            this.retry(fi, readSubject, msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void resize(FileInfo fi, Subject<FileInfo> readSubject, Subject<FileInfo> writeSubject) {
        block5: {
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Resizing ", " ..."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{Thread.currentThread().getName(), fi.file()}));
            try {
                Option<BufferedImage> option = fi.image();
                if (None$.MODULE$.equals(option)) {
                    this.retry(fi, readSubject, msg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BufferedImage img = (BufferedImage)some.x();
                    BufferedImage smallImg = JpegWriter$.MODULE$.resize(img, JpegWriter$.MODULE$.PreferredWidth());
                    Option<BufferedImage> x$6 = Option$.MODULE$.apply(smallImg);
                    File x$7 = fi.copy$default$1();
                    int x$8 = fi.copy$default$2();
                    FileInfo fiWithSmallImg = fi.copy(x$7, x$8, x$6);
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " SUCCESS!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
                    writeSubject.onNext(fiWithSmallImg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.retry(fi, readSubject, msg);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void write(FileInfo fi, File targetDir, Subject<FileInfo> readSubject) {
        block5: {
            File t = Functions$.MODULE$.sourceFileToTargetFile(fi.file(), targetDir);
            String msg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Writing ", " ..."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{Thread.currentThread().getName(), t}));
            try {
                Option<BufferedImage> option = fi.image();
                if (None$.MODULE$.equals(option)) {
                    this.retry(fi, readSubject, msg);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BufferedImage img = (BufferedImage)some.x();
                    JpegWriter$.MODULE$.write(img, t);
                    this.completedCount().getAndIncrement();
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " SUCCESS!"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                this.retry(fi, readSubject, msg);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private MainRxPar$() {
        MODULE$ = this;
        this.readSubject = Subject$.MODULE$.apply();
        this.resizeSubject = Subject$.MODULE$.apply();
        this.writeSubject = Subject$.MODULE$.apply();
        this.completedCount = new AtomicInteger();
    }
}

