/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class ReflectionTest {
    public static void main(String[] args) {
    }

    public static Object sendMessage(String message, Object target, Object[] args) {
        try {
            if (args == null) {
                return target.getClass().getMethod(message, null).invoke(target, null);
            }
            Method[] allMethods = target.getClass().getMethods();
            ArrayList<Method> candidateMethods = new ArrayList<Method>();
            for (int i = 0; i < allMethods.length; ++i) {
                Method m = allMethods[i];
                if (!m.getName().equals(message) || m.getParameterTypes().length != args.length) continue;
                candidateMethods.add(m);
            }
            if (candidateMethods.size() == 0) {
                throw new RuntimeException("");
            }
            Method callableMethod = null;
            Iterator itr = candidateMethods.iterator();
            while (itr.hasNext()) {
                boolean callable = true;
                Method m = (Method)itr.next();
                Class<?>[] argFormalTypes = m.getParameterTypes();
                for (int i = 0; i < argFormalTypes.length; ++i) {
                    if (argFormalTypes[i].isAssignableFrom(args[i].getClass())) continue;
                    callable = false;
                }
                if (!callable) continue;
                callableMethod = m;
            }
            if (callableMethod != null) {
                return callableMethod.invoke(target, args);
            }
            throw new RuntimeException("No such method found: " + message);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            try {
                int j;
                sb.append("ERROR: Could not send message '" + message + "' to target of type " + target.getClass().toString() + " \n");
                sb.append("\ttarget implements : \n");
                Class<?>[] interfaces = target.getClass().getInterfaces();
                for (int j2 = 0; j2 < interfaces.length; ++j2) {
                    sb.append("\t\t" + interfaces[j2].getName() + "\n");
                }
                sb.append("\n");
                sb.append("\ttarget methods: \n");
                Method[] methods = target.getClass().getMethods();
                for (j = 0; j < methods.length; ++j) {
                    sb.append("\t\t" + methods[j].getName() + "\n");
                }
                sb.append("\n");
                if (args != null) {
                    sb.append("\tArgument types: \n");
                    for (j = 0; j < args.length; ++j) {
                        sb.append("\t\t" + args[j].getClass().getName() + "\n");
                    }
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("ERROR: Could not create detailed error message for failed sendMessage() call.");
            }
            throw new RuntimeException(sb.toString());
        }
    }
}

