/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.mbari.swing.SpinningDialWaitIndicator;

public class LabeledSpinningDialWaitIndicator
extends SpinningDialWaitIndicator {
    private Font font;
    private String label;

    public LabeledSpinningDialWaitIndicator(JComponent target) {
        this(target, null, null);
    }

    public LabeledSpinningDialWaitIndicator(JFrame frame) {
        this(frame, null, null);
    }

    public LabeledSpinningDialWaitIndicator(JComponent target, String label) {
        this(target, label, null);
    }

    public LabeledSpinningDialWaitIndicator(JFrame frame, String label) {
        this(frame, label, null);
    }

    public LabeledSpinningDialWaitIndicator(JComponent target, String label, Font font) {
        super(target);
        this.label = label;
        this.font = font;
    }

    public LabeledSpinningDialWaitIndicator(JFrame frame, String label, Font font) {
        super(frame);
        this.label = label;
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getLabel() {
        return this.label;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JFrame f = new JFrame("Labeled dial test");
                    f.setDefaultCloseOperation(3);
                    f.setLayout(new BorderLayout());
                    URL url = f.getClass().getResource("/images/test.jpg");
                    BufferedImage image = ImageIO.read(url);
                    JLabel label = new JLabel(new ImageIcon(image));
                    f.add((Component)label, "Center");
                    f.pack();
                    f.setVisible(true);
                    final LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator(f, "This is just a test");
                    Timer timer = new Timer(2000, new ActionListener(){
                        int i = 0;
                        String[] strings = new String[]{"Changing to new text", "more text", "This class is " + this.getClass().getSimpleName(), "OK", "We're done now", "bye!!"};

                        public void actionPerformed(ActionEvent e) {
                            waitIndicator.setLabel(this.strings[this.i]);
                            ++this.i;
                            if (this.i == this.strings.length) {
                                this.i = 0;
                            }
                        }
                    });
                    timer.setRepeats(true);
                    timer.start();
                    Timer timer1 = new Timer(750, new ActionListener(){
                        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();

                        public void actionPerformed(ActionEvent e) {
                            int i = (int)Math.round(Math.random() * (double)(this.fonts.length - 1));
                            int size2 = (int)Math.round(Math.random() * 24.0) + 8;
                            Font font = new Font(this.fonts[i].getName(), 0, size2);
                            waitIndicator.setFont(font);
                        }
                    });
                    timer1.setRepeats(true);
                    timer1.start();
                }
                catch (IOException ex) {
                    System.out.println("An error occurred");
                    ex.printStackTrace();
                    System.exit(2);
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.label != null) {
            if (this.fade < 192) {
                return;
            }
            Graphics2D g2 = (Graphics2D)graphics;
            Rectangle r = this.getComponent().getVisibleRect();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color bg = this.getComponent().getForeground();
            g2.setPaint(bg);
            if (this.font != null) {
                g2.setFont(this.font);
            }
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D bounds = g2.getFont().getStringBounds(this.label, frc);
            int x = (r.width - (int)bounds.getWidth()) / 2;
            int y = (r.height + this.dial.getIconHeight() + (int)bounds.getHeight()) / 2 + 4;
            g2.drawString(this.label, x, y);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void setLabel(String label) {
        this.label = label;
        this.repaint();
    }
}

