/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.observers.SerializedObserver;
import rx.observers.SerializedSubscriber;
import rx.subjects.UnicastSubject;
import rx.subscriptions.CompositeSubscription;

public final class OperatorWindowWithStartEndObservable<T, U, V>
implements Observable.Operator<Observable<T>, T> {
    final Observable<? extends U> windowOpenings;
    final Func1<? super U, ? extends Observable<? extends V>> windowClosingSelector;

    public OperatorWindowWithStartEndObservable(Observable<? extends U> windowOpenings, Func1<? super U, ? extends Observable<? extends V>> windowClosingSelector) {
        this.windowOpenings = windowOpenings;
        this.windowClosingSelector = windowClosingSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        final SourceSubscriber sub = new SourceSubscriber(child, csub);
        Subscriber open = new Subscriber<U>(){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(U t) {
                sub.beginWindow(t);
            }

            @Override
            public void onError(Throwable e) {
                sub.onError(e);
            }

            @Override
            public void onCompleted() {
                sub.onCompleted();
            }
        };
        csub.add(sub);
        csub.add(open);
        this.windowOpenings.unsafeSubscribe(open);
        return sub;
    }

    final class SourceSubscriber
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final CompositeSubscription csub;
        final Object guard;
        final List<SerializedSubject<T>> chunks;
        boolean done;

        public SourceSubscriber(Subscriber<? super Observable<T>> child, CompositeSubscription csub) {
            this.child = new SerializedSubscriber(child);
            this.guard = new Object();
            this.chunks = new LinkedList();
            this.csub = csub;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            ArrayList list;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                list = new ArrayList(this.chunks);
            }
            for (SerializedSubject serializedSubject : list) {
                serializedSubject.consumer.onNext(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            try {
                ArrayList list;
                Object object = this.guard;
                synchronized (object) {
                    block9: {
                        if (!this.done) break block9;
                        return;
                    }
                    this.done = true;
                    list = new ArrayList(this.chunks);
                    this.chunks.clear();
                }
                for (SerializedSubject serializedSubject : list) {
                    serializedSubject.consumer.onError(e);
                }
                this.child.onError(e);
            }
            finally {
                this.csub.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            try {
                ArrayList list;
                Object object = this.guard;
                synchronized (object) {
                    block9: {
                        if (!this.done) break block9;
                        return;
                    }
                    this.done = true;
                    list = new ArrayList(this.chunks);
                    this.chunks.clear();
                }
                for (SerializedSubject serializedSubject : list) {
                    serializedSubject.consumer.onCompleted();
                }
                this.child.onCompleted();
            }
            finally {
                this.csub.unsubscribe();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginWindow(U token) {
            Observable end;
            final SerializedSubject s2 = this.createSerializedSubject();
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                this.chunks.add(s2);
            }
            this.child.onNext(s2.producer);
            try {
                end = OperatorWindowWithStartEndObservable.this.windowClosingSelector.call(token);
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
            Subscriber v = new Subscriber<V>(){
                boolean once = true;

                @Override
                public void onNext(V t) {
                    this.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onCompleted() {
                    if (this.once) {
                        this.once = false;
                        SourceSubscriber.this.endWindow(s2);
                        SourceSubscriber.this.csub.remove(this);
                    }
                }
            };
            this.csub.add(v);
            end.unsafeSubscribe(v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endWindow(SerializedSubject<T> window) {
            boolean terminate = false;
            Object object = this.guard;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                Iterator it = this.chunks.iterator();
                while (it.hasNext()) {
                    SerializedSubject s2 = it.next();
                    if (s2 != window) continue;
                    terminate = true;
                    it.remove();
                    break;
                }
            }
            if (terminate) {
                window.consumer.onCompleted();
            }
        }

        SerializedSubject<T> createSerializedSubject() {
            UnicastSubject bus = UnicastSubject.create();
            return new SerializedSubject(bus, bus);
        }
    }

    static final class SerializedSubject<T> {
        final Observer<T> consumer;
        final Observable<T> producer;

        public SerializedSubject(Observer<T> consumer, Observable<T> producer) {
            this.consumer = new SerializedObserver<T>(consumer);
            this.producer = producer;
        }
    }
}

