/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.mbari.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSimpleImageFrame
extends JFrame {
    private final JLabel label = new JLabel();
    private final JProgressBar progressBar = new JProgressBar(){
        {
            this.setIndeterminate(true);
            this.setPreferredSize(new Dimension(200, 20));
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BufferedImage image;
    private URL imageUrl;

    public JSimpleImageFrame() {
        this.initialize();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public JComponent getImageDisplayComponenet() {
        return this.label;
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    private void initialize() {
        this.setLayout(null);
        this.setImageUrl(null);
    }

    private void layoutFrame(JComponent component) {
        Dimension dimension = component.getPreferredSize();
        Insets insets = this.getInsets();
        component.setBounds(insets.left, insets.top, dimension.width, dimension.height);
        this.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public void setImageUrl(URL imageUrl) {
        this.imageUrl = imageUrl;
        this.log.debug("setImageUrl( " + imageUrl + " )");
        if (imageUrl != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JSimpleImageFrame.this.setResizable(true);
                    JSimpleImageFrame.this.setTitle(JSimpleImageFrame.this.getImageUrl().toExternalForm());
                    JSimpleImageFrame.this.remove(JSimpleImageFrame.this.label);
                    JSimpleImageFrame.this.add(JSimpleImageFrame.this.progressBar);
                    JSimpleImageFrame.this.layoutFrame(JSimpleImageFrame.this.progressBar);
                    new ImageLoader(JSimpleImageFrame.this.getImageUrl()).execute();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JSimpleImageFrame.this.setResizable(true);
                    JSimpleImageFrame.this.setTitle("");
                    JSimpleImageFrame.this.image = null;
                    JSimpleImageFrame.this.label.setText("No image available");
                    JSimpleImageFrame.this.label.setIcon(null);
                    JSimpleImageFrame.this.add(JSimpleImageFrame.this.label);
                    JSimpleImageFrame.this.layoutFrame(JSimpleImageFrame.this.label);
                    JSimpleImageFrame.this.setResizable(false);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageLoader
    extends SwingWorker<BufferedImage, Object> {
        final BufferedImage oldImage;
        final URL url;

        public ImageLoader(URL url) {
            this.url = url;
            this.oldImage = JSimpleImageFrame.this.getImage();
        }

        @Override
        protected BufferedImage doInBackground() throws Exception {
            JSimpleImageFrame.this.log.debug("Reading image from " + this.url);
            return ImageIO.read(this.url);
        }

        @Override
        protected void done() {
            JSimpleImageFrame.this.getContentPane().remove(JSimpleImageFrame.this.progressBar);
            try {
                JSimpleImageFrame.this.image = (BufferedImage)this.get();
                JSimpleImageFrame.this.log.debug("Image " + this.url + " [" + JSimpleImageFrame.this.image.getWidth() + " x " + JSimpleImageFrame.this.image.getHeight() + " pixels] has been loaded");
                JSimpleImageFrame.this.label.setText(null);
                JSimpleImageFrame.this.label.setIcon(new ImageIcon(JSimpleImageFrame.this.image));
            }
            catch (Exception e) {
                JSimpleImageFrame.this.log.debug("Failed to read image", e);
                JSimpleImageFrame.this.label.setText("Failed to fetch image from " + this.url.toExternalForm());
                JSimpleImageFrame.this.label.setIcon(null);
            }
            JSimpleImageFrame.this.getContentPane().add(JSimpleImageFrame.this.label);
            JSimpleImageFrame.this.layoutFrame(JSimpleImageFrame.this.label);
            JSimpleImageFrame.this.setResizable(false);
        }
    }
}

