/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedComboBoxModel<T>
implements MutableComboBoxModel {
    private static final Logger log = LoggerFactory.getLogger(SortedComboBoxModel.class);
    private Comparator<T> comparator;
    private List<T> itemList;
    protected EventListenerList listenerList = new EventListenerList();
    private T selectedItem;

    public SortedComboBoxModel(Comparator<T> comparator) {
        this.itemList = new ArrayList<T>();
        this.comparator = comparator;
    }

    public SortedComboBoxModel(Collection<T> items, Comparator<T> comparator) {
        this.itemList = new ArrayList<T>(items);
        this.comparator = comparator;
        if (0 < this.getSize()) {
            Collections.sort(this.itemList, comparator);
            this.selectedItem = this.getElementAt(0);
        }
    }

    public void addAll(Collection<T> items) {
        this.itemList.addAll(items);
        Collections.sort(this.itemList, this.comparator);
    }

    public void addElement(Object item) {
        Object sItem = item;
        int index = Collections.binarySearch(this.itemList, sItem, this.comparator);
        if (index < 0) {
            index = -index - 1;
            this.itemList.add(index, sItem);
        } else if (log.isInfoEnabled()) {
            log.info("Item, " + item + " already exists in the internal list. It will not be added.");
        }
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listenerList.add(ListDataListener.class, listener);
    }

    private boolean checkIndex(T item, int index) {
        boolean out = false;
        if (index < this.itemList.size()) {
            T obj = this.itemList.get(index);
            if (item == null && obj == null) {
                out = true;
            }
            if (this.comparator != null) {
                out = this.comparator.compare(obj, item) == 0;
            } else if (obj.equals(item)) {
                out = true;
            }
        }
        return out;
    }

    public void clear() {
        int size2 = this.itemList.size();
        this.itemList.clear();
        this.fireIntervalRemoved(this, 0, size2);
    }

    public boolean contains(T item) {
        return this.getItemIndex(item) > 0;
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.fireEvent(new ListDataEvent(source, 0, index0, index1));
    }

    private void fireEvent(ListDataEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; 0 <= i; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).contentsChanged(event);
        }
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.fireEvent(new ListDataEvent(source, 1, index0, index1));
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.fireEvent(new ListDataEvent(source, 2, index0, index1));
    }

    public synchronized Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public T getElementAt(int index) {
        T result2 = null;
        if (0 <= index && index < this.itemList.size()) {
            result2 = this.itemList.get(index);
        }
        return result2;
    }

    public int getItemIndex(T item) {
        int itemIndex = -1;
        if (item != null) {
            itemIndex = Collections.binarySearch(this.itemList, item, this.comparator);
        }
        return itemIndex;
    }

    public int getItemIndex(T item, int startIndex) {
        int result2 = -1;
        result2 = this.checkIndex(item, startIndex) ? startIndex : (this.checkIndex(item, startIndex + 1) ? startIndex + 1 : this.getItemIndex(item));
        return result2;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.itemList.size();
    }

    public void insertElementAt(Object object, int index) {
        throw new UnsupportedOperationException("Specifying index not allowed. Model maintains sorted ordering.");
    }

    @Override
    public void removeElement(Object object) {
        int index = this.itemList.indexOf(object);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        this.itemList.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(ListDataListener.class, listener);
    }

    public synchronized void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setItems(List<T> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
        while (this.itemList.contains(null)) {
            this.itemList.remove(null);
        }
        Collections.sort(this.itemList, this.comparator);
        if (0 < this.getSize()) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        if (this.selectedItem != null && !this.selectedItem.equals(item) || this.selectedItem == null && item != null) {
            this.selectedItem = item;
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

