/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.nativelib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.mbari.io.IOUtilities;
import org.mbari.nativelib.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Native {
    private static final Logger log = LoggerFactory.getLogger(Native.class);
    private final ClassLoader libClassLoader;
    private File libraryFile;
    private final String libraryName;
    private final File tempDirectory;
    private final String searchPathPrefix;

    public Native(String libraryName, String searchPathPrefix, File tempDirectory, ClassLoader libClassLoader) {
        this.libraryName = libraryName;
        this.searchPathPrefix = searchPathPrefix;
        this.tempDirectory = tempDirectory;
        this.libClassLoader = libClassLoader;
        try {
            System.loadLibrary(libraryName);
            log.info(libraryName + " was found on the java.library.path and loaded");
        }
        catch (UnsatisfiedLinkError e) {
            this.loadNativeLibraryFromJar();
        }
    }

    private void loadNativeLibraryFromJar() {
        String prefix;
        String osLibraryName = System.mapLibraryName(this.libraryName);
        if (osLibraryName == null) {
            throw new Error("Unable to locate a library to use for " + this.libraryName);
        }
        String string2 = prefix = this.searchPathPrefix == null ? "" : this.searchPathPrefix;
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        String fullResourceName = prefix + osLibraryName;
        log.debug("Looking for resource: " + fullResourceName);
        URL url = this.libClassLoader.getResource(fullResourceName);
        if (url == null && Platform.isMac() && osLibraryName.endsWith(".dylib")) {
            osLibraryName = osLibraryName.substring(0, osLibraryName.lastIndexOf(".dylib")) + ".jnilib";
            url = this.libClassLoader.getResource(prefix + osLibraryName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError(this.libraryName + " (" + osLibraryName + ") not found in resource path");
        }
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                this.libraryFile = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                this.libraryFile = new File(url.getPath());
            }
            if (!this.libraryFile.exists()) {
                throw new Error("File URL " + url + " could not be properly decoded");
            }
        } else {
            InputStream is = this.libClassLoader.getResourceAsStream(fullResourceName);
            if (is == null) {
                throw new Error("Can't obtain " + this.libraryName + " InputStream");
            }
            FileOutputStream fos = null;
            try {
                if (!this.tempDirectory.exists()) {
                    this.tempDirectory.mkdirs();
                }
                this.libraryFile = new File(this.tempDirectory, osLibraryName);
                this.libraryFile.deleteOnExit();
                fos = new FileOutputStream(this.libraryFile);
                IOUtilities.copy(is, fos);
                log.info(this.libraryName + " was copied from " + url.toExternalForm() + " to " + this.libraryFile.getAbsolutePath());
                if (Platform.deleteNativeLibraryAfterVMExit() && (this.libClassLoader == null || this.libClassLoader.equals(ClassLoader.getSystemClassLoader()))) {
                    Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(this.libraryFile));
                }
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for " + this.libraryName + " library: " + e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            System.load(this.libraryFile.getAbsolutePath());
            Native.addLibraryPath(this.libraryFile.getParent());
        }
        catch (Exception ex) {
            throw new Error("Failed to load the native library " + this.libraryFile.getAbsolutePath(), ex);
        }
    }

    public static void addLibraryPath(String s2) throws IOException {
        try {
            Field field2 = ClassLoader.class.getDeclaredField("usr_paths");
            field2.setAccessible(true);
            String[] paths = (String[])field2.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s2.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s2;
            field2.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + s2);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static class DeleteNativeLibrary
    extends Thread {
        private final File file;

        public DeleteNativeLibrary(File file) {
            this.file = file;
        }

        private boolean deleteNativeLibrary() {
            if (this.file == null) {
                return true;
            }
            if (this.file.delete()) {
                return true;
            }
            try {
                ClassLoader cl = Native.class.getClassLoader();
                Field f = ClassLoader.class.getDeclaredField("nativeLibraries");
                f.setAccessible(true);
                List libs = (List)f.get(cl);
                for (Object lib : libs) {
                    String path;
                    f = lib.getClass().getDeclaredField("name");
                    f.setAccessible(true);
                    String name = (String)f.get(lib);
                    if (!name.equals(path = this.file.getAbsolutePath()) && name.indexOf(path) == -1) continue;
                    Method m = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                    m.setAccessible(true);
                    m.invoke(lib, new Object[0]);
                    if (this.file.exists()) {
                        return this.file.delete();
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 5000L) continue;
                    System.err.println("Could not remove temp file: " + file.getAbsolutePath());
                    break;
                }
            }
            System.exit(0);
        }

        public void run() {
            if (!this.deleteNativeLibrary()) {
                try {
                    Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

