/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

import java.util.Date;
import java.util.GregorianCalendar;
import org.mbari.math.Matlib;
import org.mbari.util.DateConverter;
import org.mbari.util.GmtCalendar;

public class TimeUtilities {
    public static int dateToDayOfYear(Date date) {
        GmtCalendar gmt = new GmtCalendar(date);
        return gmt.get(6);
    }

    public static int dateToDayOfYear(long millis) {
        GmtCalendar gmt = new GmtCalendar(millis);
        return gmt.get(6);
    }

    public static Date dayOfYearToDate(double dayOfYear, double year) {
        int month;
        double feb = 28.0;
        double max2 = 365.0;
        if (TimeUtilities.isLeapYear(year)) {
            feb = 29.0;
            max2 = 366.0;
        }
        double[] daysPerMonth = new double[]{0.0, 31.0, feb, 31.0, 30.0, 31.0, 30.0, 31.0, 31.0, 30.0, 31.0, 30.0, 31.0};
        double[] days = Matlib.cumsum(daysPerMonth);
        while (Math.floor(dayOfYear) > max2) {
            dayOfYear -= max2;
            if (DateConverter.isLeap(year += 1.0)) {
                max2 = 366.0;
                continue;
            }
            max2 = 365.0;
        }
        for (month = 0; month < days.length && !(dayOfYear < days[month]); ++month) {
        }
        double day = dayOfYear - days[month - 1];
        double hour = (day - Math.floor(day)) * 24.0;
        double minute = (hour - Math.floor(hour)) * 60.0;
        double second = (minute - Math.floor(minute)) * 60.0;
        GmtCalendar gc = new GmtCalendar((int)year, month - 1, (int)Math.floor(day), (int)Math.floor(hour), (int)Math.floor(minute), (int)Math.rint(second));
        return gc.getTime();
    }

    public static Date dayOfYearToDate(int dayOfYear, int year) {
        return TimeUtilities.dayOfYearToDate((double)dayOfYear, (double)year);
    }

    public static Date dayOfYearToDate(float dayOfYear, int year) {
        return TimeUtilities.dayOfYearToDate((double)dayOfYear, (double)year);
    }

    public static Date dayOfYearToDate(double dayOfYear, int year) {
        return TimeUtilities.dayOfYearToDate(dayOfYear, (double)year);
    }

    public static double getJulianDate(Date date) {
        return TimeUtilities.getJulianDate(date.getTime());
    }

    public static double[] getJulianDate(long[] millis) {
        double[] julianDate = new double[millis.length];
        for (int i = 0; i < millis.length; ++i) {
            julianDate[i] = TimeUtilities.getJulianDate(millis[i]);
        }
        return julianDate;
    }

    public static double getJulianDate(long millis) {
        double startGregorian = 588829.0;
        GmtCalendar gmt = new GmtCalendar(millis);
        int year = gmt.get(1);
        int month = gmt.get(2) + 1;
        int day = gmt.get(5);
        if (gmt.get(0) == 0) {
            year = -year + 1;
        }
        double JY = year - 1;
        double JM = month + 13;
        if (month > 2) {
            JY = year;
            JM = month + 1;
        }
        double JD = Math.floor(365.25 * JY) + Math.floor(30.6001 * JM) + (double)day + 1720995.0 - 0.5;
        double JJ = day + 31 * (month + 12 * year);
        if (JJ >= startGregorian) {
            double JA = Math.floor(0.01 * JY);
            JD = JD + 2.0 - JA + Math.floor(0.25 * JA);
        }
        return JD;
    }

    public static boolean isLeapYear(double year) {
        GregorianCalendar gc = new GregorianCalendar();
        return gc.isLeapYear((int)year);
    }

    public static boolean isLeapYear(int year) {
        return DateConverter.isLeap((double)year);
    }

    public static long serialDaysToUtc(double serialDay) {
        return (long)((serialDay - 719529.0) * 1000.0 * 60.0 * 60.0 * 24.0);
    }

    public static double toSerialDays(Date d) {
        return TimeUtilities.utcToSerialDays(d.getTime());
    }

    public static double utcToSerialDays(long utc) {
        return TimeUtilities.utcToSerialDays((double)utc);
    }

    public static double utcToSerialDays(double utc) {
        return utc / 1000.0 / 60.0 / 60.0 / 24.0 + 719529.0;
    }
}

