/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

public class FormatInfo {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private boolean leftPad = true;
    private boolean leftTruncate = true;

    public FormatInfo() {
    }

    public FormatInfo(int min2, int max2) {
        this.min = min2;
        this.max = max2;
    }

    public FormatInfo(int min2, int max2, boolean leftPad, boolean leftTruncate) {
        this.min = min2;
        this.max = max2;
        this.leftPad = leftPad;
        this.leftTruncate = leftTruncate;
    }

    public static FormatInfo valueOf(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        FormatInfo fi = new FormatInfo();
        int indexOfDot = str.indexOf(46);
        String minPart = null;
        String maxPart = null;
        if (indexOfDot != -1) {
            minPart = str.substring(0, indexOfDot);
            if (indexOfDot + 1 == str.length()) {
                throw new IllegalArgumentException("Formatting string [" + str + "] should not end with '.'");
            }
            maxPart = str.substring(indexOfDot + 1);
        } else {
            minPart = str;
        }
        if (minPart != null && minPart.length() > 0) {
            int min2 = Integer.parseInt(minPart);
            if (min2 >= 0) {
                fi.min = min2;
            } else {
                fi.min = -min2;
                fi.leftPad = false;
            }
        }
        if (maxPart != null && maxPart.length() > 0) {
            int max2 = Integer.parseInt(maxPart);
            if (max2 >= 0) {
                fi.max = max2;
            } else {
                fi.max = -max2;
                fi.leftTruncate = false;
            }
        }
        return fi;
    }

    public boolean isLeftPad() {
        return this.leftPad;
    }

    public void setLeftPad(boolean leftAlign) {
        this.leftPad = leftAlign;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max2) {
        this.max = max2;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min2) {
        this.min = min2;
    }

    public boolean isLeftTruncate() {
        return this.leftTruncate;
    }

    public void setLeftTruncate(boolean leftTruncate) {
        this.leftTruncate = leftTruncate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormatInfo)) {
            return false;
        }
        FormatInfo r = (FormatInfo)o;
        return this.min == r.min && this.max == r.max && this.leftPad == r.leftPad && this.leftTruncate == r.leftTruncate;
    }

    public int hashCode() {
        int result2 = this.min;
        result2 = 31 * result2 + this.max;
        result2 = 31 * result2 + (this.leftPad ? 1 : 0);
        result2 = 31 * result2 + (this.leftTruncate ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "FormatInfo(" + this.min + ", " + this.max + ", " + this.leftPad + ", " + this.leftTruncate + ")";
    }
}

