/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.atomic;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import rx.internal.util.atomic.LinkedQueueNode;

abstract class BaseLinkedAtomicQueue<E>
extends AbstractQueue<E> {
    private final AtomicReference<LinkedQueueNode<E>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueNode<E>> consumerNode = new AtomicReference();

    protected final LinkedQueueNode<E> lvProducerNode() {
        return this.producerNode.get();
    }

    protected final LinkedQueueNode<E> lpProducerNode() {
        return this.producerNode.get();
    }

    protected final void spProducerNode(LinkedQueueNode<E> node) {
        this.producerNode.lazySet(node);
    }

    protected final LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> node) {
        return this.producerNode.getAndSet(node);
    }

    protected final LinkedQueueNode<E> lvConsumerNode() {
        return this.consumerNode.get();
    }

    protected final LinkedQueueNode<E> lpConsumerNode() {
        return this.consumerNode.get();
    }

    protected final void spConsumerNode(LinkedQueueNode<E> node) {
        this.consumerNode.lazySet(node);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int size2;
        LinkedQueueNode<E> chaserNode = this.lvConsumerNode();
        LinkedQueueNode<E> producerNode = this.lvProducerNode();
        for (size2 = 0; chaserNode != producerNode && size2 < Integer.MAX_VALUE; ++size2) {
            LinkedQueueNode<E> next2;
            while ((next2 = chaserNode.lvNext()) == null) {
            }
            chaserNode = next2;
        }
        return size2;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }
}

