/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class FlashDecorator {
    private Color backGroundColor;
    private final JComponent component;
    private boolean flashEnabled;
    private final Timer flashTimer = new Timer(300, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color fg = FlashDecorator.this.component.getForeground();
            Color bg = FlashDecorator.this.component.getBackground();
            FlashDecorator.this.component.setForeground(bg);
            FlashDecorator.this.component.setBackground(fg);
        }
    });
    private final Timer durationTimer = new Timer(1500, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            FlashDecorator.this.setFlashEnabled(false);
        }
    });
    private Color foregroundColor;

    public FlashDecorator(JComponent component) {
        this.component = component;
        this.durationTimer.setRepeats(false);
    }

    public void flash(int duration) {
        this.durationTimer.setDelay(duration);
        this.setFlashEnabled(true);
        this.durationTimer.start();
    }

    public static final void flash(JComponent component, int interval, int duration) {
        FlashDecorator flashDecorator = new FlashDecorator(component);
        flashDecorator.setFlashInterval(interval);
        flashDecorator.flash(duration);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int getFlashInterval() {
        return this.flashTimer.getDelay();
    }

    public boolean isFlashEnabled() {
        return this.flashEnabled;
    }

    public void setFlashEnabled(boolean flashEnabled) {
        if (flashEnabled) {
            if (!this.flashTimer.isRunning()) {
                this.foregroundColor = this.component.getForeground();
                this.backGroundColor = this.component.getBackground();
                this.flashTimer.start();
            }
        } else if (this.flashTimer.isRunning()) {
            this.component.setForeground(this.foregroundColor);
            this.component.setBackground(this.backGroundColor);
            this.flashTimer.stop();
        }
    }

    public void setFlashInterval(int millisec) {
        this.flashTimer.setDelay(millisec);
    }
}

