/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.Subscription;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.CompositeSubscription;

public final class CompletableOnSubscribeMergeArray
implements Completable.CompletableOnSubscribe {
    final Completable[] sources;

    public CompletableOnSubscribeMergeArray(Completable[] sources) {
        this.sources = sources;
    }

    @Override
    public void call(final Completable.CompletableSubscriber s2) {
        final CompositeSubscription set = new CompositeSubscription();
        final AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        final AtomicBoolean once = new AtomicBoolean();
        s2.onSubscribe(set);
        for (Completable c : this.sources) {
            if (set.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                set.unsubscribe();
                NullPointerException npe = new NullPointerException("A completable source is null");
                if (once.compareAndSet(false, true)) {
                    s2.onError(npe);
                    return;
                }
                RxJavaPlugins.getInstance().getErrorHandler().handleError(npe);
            }
            c.unsafeSubscribe(new Completable.CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    set.unsubscribe();
                    if (once.compareAndSet(false, true)) {
                        s2.onError(e);
                    } else {
                        RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    }
                }

                @Override
                public void onCompleted() {
                    if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
                        s2.onCompleted();
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
            s2.onCompleted();
        }
    }
}

