/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mbari.swing.SwingWorker;

public class ClockDisplay
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel timeLabel = null;
    private boolean stopClock = false;
    private DateFormat dateFormat = null;

    public ClockDisplay() {
        this.initialize();
    }

    private String getCurrentTime() {
        return this.getDateFormat().format(new Date());
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(2, 2);
        }
        return this.dateFormat;
    }

    private JLabel getTimeLabel() {
        if (this.timeLabel == null) {
            this.timeLabel = new JLabel();
            this.timeLabel.setText("JLabel");
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    while (!ClockDisplay.this.stopClock) {
                        ClockDisplay.this.timeLabel.setText(ClockDisplay.this.getCurrentTime());
                        ClockDisplay.this.timeLabel.repaint();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            System.out.println("time thread interruped");
                        }
                    }
                    return null;
                }
            };
            worker.start();
        }
        return this.timeLabel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTimeLabel(), "Center");
        this.setSize(204, 28);
    }

    public boolean isStopClock() {
        return this.stopClock;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Clock Test");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(100, 100, 500, 500);
        frame.getContentPane().add(new ClockDisplay());
        frame.setVisible(true);
    }

    public void setDateFormat(DateFormat format2) {
        this.dateFormat = format2;
    }

    public void setStopClock(boolean b) {
        this.stopClock = b;
    }
}

