/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.TreeMap;
import org.mbari.math.DoubleMath;

public class Matlib {
    public static double[] cumsum(double[] n) {
        double[] buf = new double[n.length];
        for (int i = 0; i < n.length; ++i) {
            buf[i] = i == 0 ? n[0] : buf[i - 1] + n[i];
        }
        return buf;
    }

    public static int find(double[] array, double valueToFind) {
        return Arrays.binarySearch(array, valueToFind);
    }

    public static double fix(double x) {
        int sign = DoubleMath.sign(x);
        double y = 0.0;
        if (sign == -1) {
            y = Math.ceil(x);
        } else if (sign == 1) {
            y = Math.floor(x);
        }
        return y;
    }

    public static double[] interpolate(double[] x, double[] y, double[] xi) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be the same length");
        }
        if (x.length == 1) {
            throw new IllegalArgumentException("X must contain more than one value");
        }
        double[] dx = new double[x.length - 1];
        double[] dy = new double[x.length - 1];
        double[] slope = new double[x.length - 1];
        double[] intercept = new double[x.length - 1];
        for (int i = 0; i < x.length - 1; ++i) {
            dx[i] = x[i + 1] - x[i];
            if (dx[i] == 0.0) {
                throw new IllegalArgumentException("X must be montotonic. A duplicate x-value was found");
            }
            if (dx[i] < 0.0) {
                throw new IllegalArgumentException("X must be sorted");
            }
            dy[i] = y[i + 1] - y[i];
            slope[i] = dy[i] / dx[i];
            intercept[i] = y[i] - x[i] * slope[i];
        }
        double[] yi = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            if (xi[i] > x[x.length - 1] || xi[i] < x[0]) {
                yi[i] = Double.NaN;
                continue;
            }
            int loc = Arrays.binarySearch(x, xi[i]);
            if (loc < -1) {
                loc = -loc - 2;
                yi[i] = slope[loc] * xi[i] + intercept[loc];
                continue;
            }
            yi[i] = y[loc];
        }
        return yi;
    }

    public static BigDecimal[] interpolate(BigDecimal[] x, BigDecimal[] y, BigDecimal[] xi) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be the same length");
        }
        if (x.length == 1) {
            throw new IllegalArgumentException("X must contain more than one value");
        }
        BigDecimal[] dx = new BigDecimal[x.length - 1];
        BigDecimal[] dy = new BigDecimal[x.length - 1];
        BigDecimal[] slope = new BigDecimal[x.length - 1];
        BigDecimal[] intercept = new BigDecimal[x.length - 1];
        BigInteger zero = new BigInteger("0");
        BigDecimal minusOne = new BigDecimal(-1);
        for (int i = 0; i < x.length - 1; ++i) {
            dx[i] = x[i + 1].subtract(x[i]);
            if (dx[i].equals(new BigDecimal(zero, dx[i].scale()))) {
                throw new IllegalArgumentException("X must be montotonic. A duplicate x-value was found");
            }
            if (dx[i].signum() < 0) {
                throw new IllegalArgumentException("X must be sorted");
            }
            dy[i] = y[i + 1].subtract(y[i]);
            slope[i] = dy[i].divide(dx[i]);
            intercept[i] = x[i].multiply(slope[i]).subtract(y[i]).multiply(minusOne);
        }
        BigDecimal[] yi = new BigDecimal[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            if (xi[i].compareTo(x[x.length - 1]) > 0 || xi[i].compareTo(x[0]) < 0) {
                yi[i] = null;
                continue;
            }
            int loc = Arrays.binarySearch(x, xi[i]);
            if (loc < -1) {
                loc = -loc - 2;
                yi[i] = slope[loc].multiply(xi[i]).add(intercept[loc]);
                continue;
            }
            yi[i] = y[loc];
        }
        return yi;
    }

    public static double[] interpolate(long[] x, double[] y, long[] xi) throws IllegalArgumentException {
        double[] xd = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xd[i] = x[i];
        }
        double[] xid = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            xid[i] = xi[i];
        }
        return Matlib.interpolate(xd, y, xid);
    }

    public static double[] linspace(double d1, double d2, int n) {
        double[] y = new double[n];
        double dy = (d2 - d1) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            y[i] = d1 + dy * (double)i;
        }
        return y;
    }

    public static double[] logspace(double d1, double d2, int n) {
        return Matlib.logspace(d1, d2, n, 10.0);
    }

    public static double[] logspace(double d1, double d2, int n, double base) {
        double[] y = new double[n];
        double[] p = Matlib.linspace(d1, d2, n);
        for (int i = 0; i < y.length - 1; ++i) {
            y[i] = Math.pow(base, p[i]);
        }
        y[y.length - 1] = Math.pow(base, d2);
        return y;
    }

    public static int near(double[] values, double key) {
        return Matlib.near(values, key, false);
    }

    public static int near(double[] values, double key, boolean inclusive2) {
        int n = -1;
        boolean outsideValues = false;
        if (!inclusive2) {
            if (key <= values[0]) {
                n = 0;
                outsideValues = true;
            } else if (key >= values[values.length - 1]) {
                n = values.length - 1;
                outsideValues = true;
            }
        }
        if (!outsideValues && (n = Arrays.binarySearch(values, key)) < 0) {
            n = -n - 1;
            if (inclusive2 && (n == 0 || n >= values.length)) {
                n = -1;
            } else if (n > values.length - 1) {
                n = values.length - 1;
            } else if (n > 0) {
                double d2;
                double d1 = Math.abs(values[n - 1] - key);
                n = d1 <= (d2 = Math.abs(values[n] - key)) ? n - 1 : n;
            }
        }
        return n;
    }

    public static Integer nearInclusive(double[] array, double value) {
        Integer i = null;
        int idx = Arrays.binarySearch(array, value);
        if (idx < 0) {
            if ((idx = -idx - 1) != 0 && idx < array.length) {
                double d1;
                double d0 = Math.abs(array[idx - 1] - value);
                i = d0 <= (d1 = Math.abs(array[idx] - value)) ? idx - 1 : idx;
            }
        } else {
            i = idx;
        }
        return i;
    }

    public static double[] reorder(double[] values, int[] order) {
        double[] out = new double[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }

    public static float[] reorder(float[] values, int[] order) {
        float[] out = new float[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }

    public static long[] reorder(long[] values, int[] order) {
        long[] out = new long[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }

    public static double sum(double[] values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("The data array either is null or does not contain any data.");
        }
        double sum2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum2 += values[i];
        }
        return sum2;
    }

    public static synchronized int[] uniqueSort(double[] x) {
        TreeMap<Double, Integer> tm = new TreeMap<Double, Integer>();
        for (int i = 0; i < x.length; ++i) {
            Double key = new Double(x[i]);
            boolean exists2 = tm.containsKey(key);
            if (exists2) continue;
            tm.put(key, new Integer(i));
        }
        Object[] values = tm.values().toArray();
        int[] order = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer tmp = (Integer)values[i];
            order[i] = tmp;
        }
        return order;
    }

    public static final synchronized int[] uniqueSort(long[] x) {
        TreeMap<Long, Integer> tm = new TreeMap<Long, Integer>();
        for (int i = 0; i < x.length; ++i) {
            Long key = new Long(x[i]);
            boolean exists2 = tm.containsKey(key);
            if (exists2) continue;
            tm.put(key, new Integer(i));
        }
        Object[] values = tm.values().toArray();
        int[] order = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer tmp = (Integer)values[i];
            order[i] = tmp;
        }
        return order;
    }
}

