/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SplashFrame
extends JFrame {
    private static final long serialVersionUID = -4993476492124824111L;
    private final ImageIcon imageIcon;
    private JLabel messageLabel;
    private JPanel splashPanel;

    public SplashFrame(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
        this.initialize();
    }

    private JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel(" ");
        }
        return this.messageLabel;
    }

    private JPanel getSplashPanel() {
        if (this.splashPanel == null) {
            this.splashPanel = new JPanel(false);
            this.splashPanel.setLayout(new BoxLayout(this.splashPanel, 1));
            this.splashPanel.add(new JLabel(this.imageIcon));
            this.splashPanel.add(this.getMessageLabel());
        }
        return this.splashPanel;
    }

    private void initialize() {
        this.setResizable(false);
        this.setUndecorated(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        this.getContentPane().add("Center", this.getSplashPanel());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setMessage(String msg) {
        this.getMessageLabel().setText(msg);
        this.repaint();
    }
}

