/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.DataBuffer;
import javax.media.jai.JaiI18N;

public class DataBufferDouble
extends DataBuffer {
    protected double[][] bankdata;
    protected double[] data;

    public DataBufferDouble(int size2) {
        super(5, size2);
        this.data = new double[size2];
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(int size2, int numBanks) {
        super(5, size2, numBanks);
        this.bankdata = new double[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            this.bankdata[i] = new double[size2];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferDouble(double[] dataArray, int size2) {
        super(5, size2);
        if (dataArray.length < size2) {
            throw new RuntimeException(JaiI18N.getString("DataBuffer0"));
        }
        this.data = dataArray;
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(double[] dataArray, int size2, int offset) {
        super(5, size2, 1, offset);
        if (dataArray.length < size2) {
            throw new RuntimeException(JaiI18N.getString("DataBuffer1"));
        }
        this.data = dataArray;
        this.bankdata = new double[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferDouble(double[][] dataArray, int size2) {
        super(5, size2, dataArray.length);
        this.bankdata = dataArray;
        this.data = this.bankdata[0];
    }

    public DataBufferDouble(double[][] dataArray, int size2, int[] offsets) {
        super(5, size2, dataArray.length, offsets);
        this.bankdata = dataArray;
        this.data = this.bankdata[0];
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getData(int bank) {
        return this.bankdata[bank];
    }

    public double[][] getBankData() {
        return this.bankdata;
    }

    public int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    public int getElem(int bank, int i) {
        return (int)this.bankdata[bank][i + this.offsets[bank]];
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    public void setElem(int bank, int i, int val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
    }

    public float getElemFloat(int i) {
        return (float)this.data[i + this.offset];
    }

    public float getElemFloat(int bank, int i) {
        return (float)this.bankdata[bank][i + this.offsets[bank]];
    }

    public void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
    }

    public void setElemFloat(int bank, int i, float val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
    }

    public double getElemDouble(int i) {
        return this.data[i + this.offset];
    }

    public double getElemDouble(int bank, int i) {
        return this.bankdata[bank][i + this.offsets[bank]];
    }

    public void setElemDouble(int i, double val) {
        this.data[i + this.offset] = val;
    }

    public void setElemDouble(int bank, int i, double val) {
        this.bankdata[bank][i + this.offsets[bank]] = val;
    }
}

