/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.SpacePadder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    public final void setFormattingInfo(FormatInfo formattingInfo) {
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = formattingInfo;
    }

    @Override
    public final void write(StringBuilder buf, E event) {
        String s2 = this.convert(event);
        if (this.formattingInfo == null) {
            buf.append(s2);
            return;
        }
        int min2 = this.formattingInfo.getMin();
        int max2 = this.formattingInfo.getMax();
        if (s2 == null) {
            if (0 < min2) {
                SpacePadder.spacePad(buf, min2);
            }
            return;
        }
        int len = s2.length();
        if (len > max2) {
            if (this.formattingInfo.isLeftTruncate()) {
                buf.append(s2.substring(len - max2));
            } else {
                buf.append(s2.substring(0, max2));
            }
        } else if (len < min2) {
            if (this.formattingInfo.isLeftPad()) {
                SpacePadder.leftPad(buf, s2, min2);
            } else {
                SpacePadder.rightPad(buf, s2, min2);
            }
        } else {
            buf.append(s2);
        }
    }
}

