/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadCheckingRepaintManager.class);

    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThread();
        super.addInvalidComponent(jComponent);
    }

    private void checkThread() {
        if (!SwingUtilities.isEventDispatchThread() && log.isWarnEnabled()) {
            Map<Thread, StackTraceElement[]> map2 = Thread.getAllStackTraces();
            StackTraceElement[] elements = map2.get(Thread.currentThread());
            StringBuilder b = new StringBuilder("A swing component was modified on the Thread:");
            b.append(Thread.currentThread().getName()).append("\n");
            for (StackTraceElement element : elements) {
                b.append("\t").append(element.toString()).append("\n");
            }
            b.append("The code should be changed so that Swing components are always modified on the swing EventDispatchThread");
        }
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int i, int i1, int i2, int i3) {
        this.checkThread();
        super.addDirtyRegion(jComponent, i, i1, i2, i3);
    }
}

