/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.geovrml;

public class Quaternion {
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaternion() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public void rotation(double d, double d2, double d3, double d4) {
        double d5 = d4 / 2.0 * (Math.PI / 180);
        double d6 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d7 = Math.sin(d5) / d6;
        this.x = d7 * d;
        this.y = d7 * d2;
        this.z = d7 * d3;
        this.w = Math.cos(d5);
    }

    public void add(Quaternion quaternion, Quaternion quaternion2) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = quaternion2.w * quaternion.x;
        dArray[1] = quaternion2.w * quaternion.y;
        dArray[2] = quaternion2.w * quaternion.z;
        dArray2[0] = quaternion.w * quaternion2.x;
        dArray2[1] = quaternion.w * quaternion2.y;
        dArray2[2] = quaternion.w * quaternion2.z;
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
        dArray[2] = dArray[2] + dArray2[2];
        dArray2[0] = quaternion2.y * quaternion.z - quaternion2.z * quaternion.y;
        dArray2[1] = quaternion2.z * quaternion.x - quaternion2.x * quaternion.z;
        dArray2[2] = quaternion2.x * quaternion.y - quaternion2.y * quaternion.x;
        this.x = dArray[0] + dArray2[0];
        this.y = dArray[1] + dArray2[1];
        this.z = dArray[2] + dArray2[2];
        this.w = quaternion.w * quaternion2.w - (quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z);
    }

    public void multiply(Quaternion quaternion, Quaternion quaternion2) {
        this.w = quaternion.w * quaternion2.w - quaternion.x * quaternion2.x - quaternion.y * quaternion2.y - quaternion.z * quaternion2.z;
        this.x = quaternion.w * quaternion2.x + quaternion.x * quaternion2.w + quaternion.y * quaternion2.z - quaternion.z * quaternion2.y;
        this.y = quaternion.w * quaternion2.y - quaternion.x * quaternion2.z + quaternion.y * quaternion2.w + quaternion.z * quaternion2.x;
        this.z = quaternion.w * quaternion2.z + quaternion.x * quaternion2.y - quaternion.y * quaternion2.x + quaternion.z * quaternion2.w;
    }

    public double axis_angle(double[] dArray) {
        double d = this.w;
        double d2 = Math.acos(d);
        double d3 = Math.sin(d2);
        double d4 = 1.0 / d3;
        dArray[0] = d4 * this.x;
        dArray[1] = d4 * this.y;
        dArray[2] = d4 * this.z;
        return 2.0 * d2;
    }
}

