/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.geovrml;

import geotransform.coords.Gcc_Coord_3d;
import geotransform.coords.Gdc_Coord_3d;
import geotransform.ellipsoids.WE_Ellipsoid;
import geotransform.transforms.Gcc_To_Gdc_Converter;
import java.util.Vector;
import org.web3d.geovrml.CoordParser;
import org.web3d.geovrml.Quaternion;
import vrml.InvalidExposedFieldException;
import vrml.field.MFString;
import vrml.field.SFNode;
import vrml.field.SFString;
import vrml.node.Node;

public class GeoVRML {
    public double scaleFactor = 1.0;
    private Gcc_Coord_3d geo_origin;

    public String getVersion() {
        return "1.0";
    }

    public boolean setOrigin(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        CoordParser coordParser = new CoordParser(string, string2);
        this.geo_origin = coordParser.getNextCoord();
        return this.geo_origin != null;
    }

    public boolean setOrigin(SFNode sFNode) {
        SFString sFString;
        MFString mFString;
        if (sFNode == null) {
            return false;
        }
        Node node = (Node)sFNode.getValue();
        if (node == null) {
            return false;
        }
        try {
            mFString = (MFString)node.getExposedField("geoSystem");
        }
        catch (InvalidExposedFieldException invalidExposedFieldException) {
            System.out.println("No exposedField geoSystem in GeoOrigin node");
            return false;
        }
        try {
            sFString = (SFString)node.getExposedField("geoCoords");
        }
        catch (InvalidExposedFieldException invalidExposedFieldException) {
            System.out.println("No exposedField geoCoords in GeoOrigin node");
            return false;
        }
        if (mFString == null || sFString == null) {
            return false;
        }
        return this.setOrigin(GeoVRML.VRMLToString(sFString), GeoVRML.VRMLToString(mFString));
    }

    public Gcc_Coord_3d getOrigin() {
        return this.geo_origin;
    }

    public Gcc_Coord_3d getCoord(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        CoordParser coordParser = new CoordParser(string, string2);
        Gcc_Coord_3d gcc_Coord_3d = coordParser.getNextCoord();
        this.applyOrigin(gcc_Coord_3d);
        return gcc_Coord_3d;
    }

    public Gcc_Coord_3d getCoord(SFString sFString, MFString mFString) {
        return this.getCoord(GeoVRML.VRMLToString(sFString), GeoVRML.VRMLToString(mFString));
    }

    public Gcc_Coord_3d getCoord(MFString mFString, MFString mFString2) {
        return this.getCoord(GeoVRML.VRMLToString(mFString), GeoVRML.VRMLToString(mFString2));
    }

    public Gcc_Coord_3d[] getCoords(String string, String string2) {
        Gcc_Coord_3d[] gcc_Coord_3dArray;
        if (string == null || string2 == null) {
            return null;
        }
        Vector<Gcc_Coord_3d[]> vector = new Vector<Gcc_Coord_3d[]>(256, 256);
        CoordParser coordParser = new CoordParser(string, string2);
        while (!coordParser.isDone()) {
            gcc_Coord_3dArray = coordParser.getNextCoord();
            if (gcc_Coord_3dArray == null) continue;
            this.applyOrigin((Gcc_Coord_3d)gcc_Coord_3dArray);
            vector.addElement(gcc_Coord_3dArray);
        }
        if (vector.size() <= 0) {
            return null;
        }
        gcc_Coord_3dArray = new Gcc_Coord_3d[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            gcc_Coord_3dArray[n] = (Gcc_Coord_3d)vector.elementAt(n);
            ++n;
        }
        vector = null;
        return gcc_Coord_3dArray;
    }

    public Gcc_Coord_3d[] getCoords(SFString sFString, MFString mFString) {
        return this.getCoords(GeoVRML.VRMLToString(sFString), GeoVRML.VRMLToString(mFString));
    }

    public Gcc_Coord_3d[] getCoords(MFString mFString, MFString mFString2) {
        return this.getCoords(GeoVRML.VRMLToString(mFString), GeoVRML.VRMLToString(mFString2));
    }

    private void applyOrigin(Gcc_Coord_3d gcc_Coord_3d) {
        if (this.geo_origin != null) {
            gcc_Coord_3d.x -= this.geo_origin.x;
            gcc_Coord_3d.y -= this.geo_origin.y;
            gcc_Coord_3d.z -= this.geo_origin.z;
        }
        if (this.scaleFactor != 1.0 && this.scaleFactor != 0.0) {
            gcc_Coord_3d.x /= this.scaleFactor;
            gcc_Coord_3d.y /= this.scaleFactor;
            gcc_Coord_3d.z /= this.scaleFactor;
        }
    }

    private void retractOrigin(Gcc_Coord_3d gcc_Coord_3d) {
        if (this.scaleFactor != 1.0 && this.scaleFactor != 0.0) {
            gcc_Coord_3d.x *= this.scaleFactor;
            gcc_Coord_3d.y *= this.scaleFactor;
            gcc_Coord_3d.z *= this.scaleFactor;
        }
        if (this.geo_origin != null) {
            gcc_Coord_3d.x += this.geo_origin.x;
            gcc_Coord_3d.y += this.geo_origin.y;
            gcc_Coord_3d.z += this.geo_origin.z;
        }
    }

    public double getElevation(double d, double d2, double d3) {
        Gcc_Coord_3d gcc_Coord_3d = new Gcc_Coord_3d(d, d2, d3);
        this.retractOrigin(gcc_Coord_3d);
        Gdc_Coord_3d gdc_Coord_3d = new Gdc_Coord_3d();
        Gcc_To_Gdc_Converter.Init(new WE_Ellipsoid());
        Gcc_To_Gdc_Converter.Convert(gcc_Coord_3d, gdc_Coord_3d);
        return gdc_Coord_3d.elevation;
    }

    public void getLocalOrientation(Gdc_Coord_3d gdc_Coord_3d, float[] fArray) {
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        Quaternion quaternion3 = new Quaternion();
        quaternion2.rotation(0.0, 0.0, 1.0, 90.0 + gdc_Coord_3d.longitude);
        quaternion.rotation(1.0, 0.0, 0.0, 180.0 - gdc_Coord_3d.latitude);
        quaternion3.add(quaternion, quaternion2);
        double[] dArray = new double[3];
        double d = quaternion3.axis_angle(dArray);
        fArray[0] = (float)dArray[0];
        fArray[1] = (float)dArray[1];
        fArray[2] = (float)dArray[2];
        fArray[3] = (float)d;
    }

    public void getLocalOrientation(Gcc_Coord_3d gcc_Coord_3d, float[] fArray) {
        Gcc_Coord_3d gcc_Coord_3d2 = new Gcc_Coord_3d(gcc_Coord_3d.x, gcc_Coord_3d.y, gcc_Coord_3d.z);
        this.retractOrigin(gcc_Coord_3d2);
        Gdc_Coord_3d gdc_Coord_3d = new Gdc_Coord_3d();
        Gcc_To_Gdc_Converter.Init(new WE_Ellipsoid());
        Gcc_To_Gdc_Converter.Convert(gcc_Coord_3d2, gdc_Coord_3d);
        this.getLocalOrientation(gdc_Coord_3d, fArray);
    }

    public String addCoord(String string, double d, double d2, double d3, String string2) {
        if (string2.indexOf("GDC") >= 0) {
            double d4 = this.getNthValue(string, 0);
            double d5 = this.getNthValue(string, 1);
            double d6 = this.getNthValue(string, 2);
            return String.valueOf(d4 += d2) + " " + (d5 += d) + " " + (d6 += d3);
        }
        if (string2.indexOf("UTM") >= 0) {
            double d7 = this.getNthValue(string, 0);
            double d8 = this.getNthValue(string, 1);
            double d9 = this.getNthValue(string, 2);
            double d10 = this.getNthValue(string, 3);
            return "Z" + d7 + " " + (d8 += d2) + " " + (d9 += d) + " " + (d10 += d3);
        }
        System.out.println("unsupported geoSystem: " + string2);
        return null;
    }

    public String linterp(String string, String string2, float f, String string3) {
        if (string3.indexOf("GDC") >= 0) {
            double d = this.getNthValue(string, 0);
            double d2 = this.getNthValue(string, 1);
            double d3 = this.getNthValue(string, 2);
            double d4 = this.getNthValue(string2, 0);
            double d5 = this.getNthValue(string2, 1);
            double d6 = this.getNthValue(string2, 2);
            double d7 = d + (d4 - d) * (double)f;
            double d8 = d2 + (d5 - d2) * (double)f;
            double d9 = d3 + (d6 - d3) * (double)f;
            return String.valueOf(d7) + " " + d8 + " " + d9;
        }
        if (string3.indexOf("GCC") >= 0) {
            double d = this.getNthValue(string, 0);
            double d10 = this.getNthValue(string, 1);
            double d11 = this.getNthValue(string, 2);
            double d12 = this.getNthValue(string2, 0);
            double d13 = this.getNthValue(string2, 1);
            double d14 = this.getNthValue(string2, 2);
            double d15 = d + (d12 - d) * (double)f;
            double d16 = d10 + (d13 - d10) * (double)f;
            double d17 = d11 + (d14 - d11) * (double)f;
            return String.valueOf(d15) + " " + d16 + " " + d17;
        }
        if (string3.indexOf("UTM") >= 0) {
            double d = this.getNthValue(string, 0);
            double d18 = this.getNthValue(string, 1);
            double d19 = this.getNthValue(string, 2);
            double d20 = this.getNthValue(string, 3);
            double d21 = this.getNthValue(string2, 0);
            double d22 = this.getNthValue(string2, 1);
            double d23 = this.getNthValue(string2, 2);
            double d24 = this.getNthValue(string2, 3);
            double d25 = d + (d21 - d) * (double)f;
            double d26 = d18 + (d22 - d18) * (double)f;
            double d27 = d19 + (d23 - d19) * (double)f;
            double d28 = d20 + (d24 - d20) * (double)f;
            return "Z" + d25 + " " + d26 + " " + d27 + " " + d28;
        }
        System.out.println("unsupported geoSystem: " + string3);
        return string;
    }

    private double getNthValue(String string, int n) {
        if (n < 0) {
            return 0.0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        while (n5 <= n) {
            n3 = n2;
            while (n3 < n4 && (string.charAt(n3) <= ' ' || string.charAt(n3) == 'Z' || string.charAt(n3) == 'z')) {
                ++n3;
            }
            if (n3 >= n4) {
                return 0.0;
            }
            n2 = n3 + 1;
            while (n2 < n4 && string.charAt(n2) > ' ') {
                ++n2;
            }
            ++n5;
        }
        String string2 = string.substring(n3, n2);
        return Double.valueOf(string2);
    }

    public static String VRMLToString(MFString mFString) {
        if (mFString == null) {
            return null;
        }
        String string = new String();
        int n = mFString.getSize();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + mFString.get1Value(n2) + " ";
            ++n2;
        }
        return string;
    }

    public static String VRMLToString(SFString sFString) {
        if (sFString == null) {
            return null;
        }
        return sFString.getValue();
    }
}

