/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.geovrml;

import geotransform.coords.Gcc_Coord_3d;
import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Utm_Coord_3d;
import geotransform.ellipsoids.WE_Ellipsoid;
import geotransform.transforms.Gdc_To_Gcc_Converter;
import geotransform.transforms.Utm_To_Gcc_Converter;

class CoordParser {
    public static final double INVALID_VALUE = -9.876543211234568E8;
    private int curr_index = 0;
    private int no_of_chars;
    private String curr_string;
    private int geo_system = 0;
    private final int GEO_NONE = 0;
    private final int GEO_GDC = 1;
    private final int GEO_GCC = 2;
    private final int GEO_UTM = 3;
    private final int GEO_VRML = 4;

    CoordParser(String string, String string2) {
        if (string2 != null) {
            if (string2.indexOf("GDC") >= 0) {
                this.geo_system = 1;
            } else if (string2.indexOf("UTM") >= 0) {
                this.geo_system = 3;
            } else if (string2.indexOf("GCC") >= 0) {
                this.geo_system = 2;
            } else if (string2.indexOf("VRML") >= 0) {
                this.geo_system = 4;
            } else {
                System.out.println("Unsupported coord system: " + string2);
            }
        }
        if (string == null) {
            this.curr_string = null;
            this.no_of_chars = 0;
            return;
        }
        this.curr_string = new String(String.valueOf(string) + " ");
        this.no_of_chars = this.curr_string.length();
    }

    public boolean isDone() {
        return this.curr_string == null || this.curr_index >= this.no_of_chars - 1;
    }

    private static boolean isWhitespace(char c) {
        return c <= ' ' || c == ',' || c == '[' || c == ']' || c == '\"' || c == 'Z' || c == 'z';
    }

    /*
     * Unable to fully structure code
     */
    public double getNextValue() {
        if (this.curr_string != null) ** GOTO lbl4
        return -9.876543211234568E8;
lbl-1000:
        // 1 sources

        {
            ++this.curr_index;
lbl4:
            // 2 sources

            ** while (this.curr_index < this.no_of_chars && CoordParser.isWhitespace((char)this.curr_string.charAt((int)this.curr_index)))
        }
lbl5:
        // 1 sources

        if (this.isDone()) {
            return -9.876543211234568E8;
        }
        var1_1 = this.curr_index + 1;
        while (this.curr_index < this.no_of_chars && !CoordParser.isWhitespace(this.curr_string.charAt(var1_1))) {
            ++var1_1;
        }
        var2_2 = new Double(this.curr_string.substring(this.curr_index, var1_1));
        this.curr_index = var1_1;
        return var2_2;
    }

    public Gcc_Coord_3d getNextCoord() {
        if (this.geo_system == 0 || this.isDone()) {
            return null;
        }
        Gcc_Coord_3d gcc_Coord_3d = new Gcc_Coord_3d();
        switch (this.geo_system) {
            case 1: {
                Gdc_Coord_3d gdc_Coord_3d = new Gdc_Coord_3d();
                gdc_Coord_3d.latitude = this.getNextValue();
                gdc_Coord_3d.longitude = this.getNextValue();
                gdc_Coord_3d.elevation = this.getNextValue();
                if (gdc_Coord_3d.elevation == -9.876543211234568E8) {
                    return null;
                }
                Gdc_To_Gcc_Converter.Init(new WE_Ellipsoid());
                Gdc_To_Gcc_Converter.Convert(gdc_Coord_3d, gcc_Coord_3d);
                break;
            }
            case 2: 
            case 4: {
                gcc_Coord_3d.x = this.getNextValue();
                gcc_Coord_3d.y = this.getNextValue();
                gcc_Coord_3d.z = this.getNextValue();
                if (gcc_Coord_3d.z != -9.876543211234568E8) break;
                return null;
            }
            case 3: {
                Utm_Coord_3d utm_Coord_3d = new Utm_Coord_3d();
                utm_Coord_3d.zone = (byte)this.getNextValue();
                utm_Coord_3d.y = this.getNextValue();
                utm_Coord_3d.x = this.getNextValue();
                utm_Coord_3d.z = this.getNextValue();
                if (utm_Coord_3d.z == -9.876543211234568E8) {
                    return null;
                }
                if (utm_Coord_3d.y < 0.0) {
                    utm_Coord_3d.hemisphere_north = false;
                    utm_Coord_3d.y = -utm_Coord_3d.y;
                } else {
                    utm_Coord_3d.hemisphere_north = true;
                }
                Utm_To_Gcc_Converter.Init(new WE_Ellipsoid());
                Utm_To_Gcc_Converter.Convert(utm_Coord_3d, gcc_Coord_3d);
                break;
            }
        }
        return gcc_Coord_3d;
    }
}

