/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Utm_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Utm_To_Gdc_Converter {
    static final double DEGREES_PER_RADIAN = 57.29577951308232;
    static double A;
    static double F;
    static double C;
    static double Eps2;
    static double Eps21;
    static double Eps25;
    static double Con;
    static double Con2;
    static double EF;
    static double Epsp2;
    static double Con6;
    static double Con24;
    static double Con120;
    static double Con720;
    static double polx2b;
    static double polx3b;
    static double polx4b;
    static double polx5b;
    static double conap;

    public static void Init(double d, double d2) {
        Utm_To_Gdc_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Utm_To_Gdc_Converter.CreateConstants(6378137.0, 298.257223563);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Utm_To_Gdc_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        A = d;
        F = d2;
        F = 1.0 / F;
        C = A * (1.0 - F);
        Eps2 = F * (2.0 - F);
        Eps25 = 0.25 * Eps2;
        EF = F / (2.0 - F);
        Con = 1.0 - Eps2;
        Con2 = 2.0 / (1.0 - Eps2);
        Con6 = 0.166666666666667;
        Con24 = 0.1666666666666668 / (1.0 - Eps2);
        Con120 = 0.00833333333333333;
        Con720 = 0.00555555555555552 / (1.0 - Eps2);
        double d3 = 1.0 - Eps2 / 4.0 - 0.046875 * Math.pow(Eps2, 2.0) - 0.01953125 * Math.pow(Eps2, 3.0) - 0.01068115234375 * Math.pow(Eps2, 4.0);
        conap = A * d3;
        double d4 = 1.5 * EF - 0.84375 * Math.pow(EF, 3.0);
        double d5 = 1.3125 * Math.pow(EF, 2.0) - 1.71875 * Math.pow(EF, 4.0);
        double d6 = 1.5729166666666667 * Math.pow(EF, 3.0);
        double d7 = 2.142578125 * Math.pow(EF, 4.0);
        polx2b = d4 * 2.0 + d5 * 4.0 + d6 * 6.0 + d7 * 8.0;
        polx3b = d5 * -8.0 - d6 * 32.0 - 80.0 * d7;
        polx4b = d6 * 32.0 + 192.0 * d7;
        polx5b = -128.0 * d7;
    }

    public static void Convert(Utm_Coord_3d utm_Coord_3d, Gdc_Coord_3d gdc_Coord_3d) {
        Utm_Coord_3d[] utm_Coord_3dArray = new Utm_Coord_3d[1];
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        utm_Coord_3dArray[0] = utm_Coord_3d;
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        Utm_To_Gdc_Converter.Convert(utm_Coord_3dArray, gdc_Coord_3dArray);
    }

    public static void Convert(Utm_Coord_3d[] utm_Coord_3dArray, Gdc_Coord_3d[] gdc_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            gdc_Coord_3dArray[n].elevation = utm_Coord_3dArray[n].z;
            double d = utm_Coord_3dArray[n].x;
            d = (d - 500000.0) / 0.9996;
            double d2 = utm_Coord_3dArray[n].hemisphere_north ? utm_Coord_3dArray[n].y / 0.9996 : (utm_Coord_3dArray[n].y - 1.0E7) / 0.9996;
            double d3 = d2 / conap;
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = d4 * d4;
            double d7 = (6.0 * (double)utm_Coord_3dArray[n].zone - 183.0) / 57.29577951308232;
            double d8 = polx2b + d6 * (polx3b + d6 * (polx4b + d6 * polx5b));
            double d9 = d3 + d4 * d5 * d8;
            double d10 = Math.sin(d9);
            double d11 = Math.cos(d9);
            double d12 = d10 / d11;
            double d13 = d12 * d12;
            double d14 = d10 * d10;
            double d15 = d11 * d11;
            double d16 = Epsp2 * d15;
            double d17 = 0.25 - d14 * (Eps2 / 4.0);
            double d18 = A / (0.25 - Eps25 * d14 + 0.249998608869975 + (0.25 - Eps25 * d14) / (0.25 - Eps25 * d14 + 0.249998608869975));
            double d19 = 1.0 + d13 + d13 + d16;
            double d20 = 5.0 + d13 * (3.0 - 9.0 * d16) + d16 * (1.0 - 4.0 * d16);
            double d21 = 5.0 + d13 * (d13 * 24.0 + 28.0);
            d21 += d16 * (d13 * 8.0 + 6.0);
            double d22 = 46.0 - 3.0 * d16 + d13 * (-252.0 - d13 * 90.0);
            d22 = d16 * (d22 + d16 * d13 * (d13 * 225.0 - 66.0));
            double d23 = d / d18;
            double d24 = d23 * d23;
            gdc_Coord_3dArray[n].latitude = d9 - d12 * d17 * (d24 * (Con2 + d24 * (-Con24 * d20 + d24 * Con720 * (d22 += 61.0 + d13 * (d13 * 45.0 + 90.0)))));
            gdc_Coord_3dArray[n].longitude = d7 + d23 * (1.0 + d24 * (-Con6 * d19 + d24 * Con120 * d21)) / d11;
            gdc_Coord_3dArray[n].latitude *= 57.29577951308232;
            gdc_Coord_3dArray[n].longitude *= 57.29577951308232;
            ++n;
        }
    }
}

