/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gcc_Coord_3d;
import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Utm_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;
import geotransform.transforms.Gdc_To_Gcc_Converter;
import geotransform.transforms.Utm_To_Gdc_Converter;

public class Utm_To_Gcc_Converter {
    protected static Ellipsoid e;
    protected static double A;
    protected static double F;

    public static void Init(double d, double d2) {
        A = d;
        F = d2;
    }

    public static void Init() {
        A = 6378137.0;
        F = 298.257223563;
    }

    public static void Init(Ellipsoid ellipsoid) {
        e = ellipsoid;
        A = Utm_To_Gcc_Converter.e.a;
        F = Utm_To_Gcc_Converter.e.f;
    }

    public static void Convert(Utm_Coord_3d utm_Coord_3d, Gcc_Coord_3d gcc_Coord_3d) {
        Utm_Coord_3d[] utm_Coord_3dArray = new Utm_Coord_3d[1];
        Gcc_Coord_3d[] gcc_Coord_3dArray = new Gcc_Coord_3d[1];
        utm_Coord_3dArray[0] = utm_Coord_3d;
        gcc_Coord_3dArray[0] = gcc_Coord_3d;
        Utm_To_Gcc_Converter.Convert(utm_Coord_3dArray, gcc_Coord_3dArray);
    }

    public static void Convert(Utm_Coord_3d[] utm_Coord_3dArray, Gcc_Coord_3d[] gcc_Coord_3dArray) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[utm_Coord_3dArray.length];
        int n = 0;
        while (n < utm_Coord_3dArray.length) {
            gdc_Coord_3dArray[n] = new Gdc_Coord_3d();
            ++n;
        }
        Utm_To_Gdc_Converter.Init(A, F);
        Utm_To_Gdc_Converter.Convert(utm_Coord_3dArray, gdc_Coord_3dArray);
        Gdc_To_Gcc_Converter.Init(A, F);
        Gdc_To_Gcc_Converter.Convert(gdc_Coord_3dArray, gcc_Coord_3dArray);
    }
}

