/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gcc_Coord_3d;
import geotransform.coords.Gdc_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gdc_To_Gcc_Converter {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static double A;
    static double F;
    static double A2;
    static double C;
    static double C2;
    static double Eps2;
    static double Eps25;

    public static void Init(double d, double d2) {
        Gdc_To_Gcc_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Gdc_To_Gcc_Converter.CreateConstants(6378137.0, 298.257223563);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Gdc_To_Gcc_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        A = d;
        F = d2;
        A2 = A * A;
        F = 1.0 / F;
        C = A * (1.0 - F);
        C2 = C * C;
        Eps2 = F * (2.0 - F);
        Eps25 = 0.25 * Eps2;
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, Gcc_Coord_3d gcc_Coord_3d) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        Gcc_Coord_3d[] gcc_Coord_3dArray = new Gcc_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        gcc_Coord_3dArray[0] = gcc_Coord_3d;
        Gdc_To_Gcc_Converter.Convert(gdc_Coord_3dArray, gcc_Coord_3dArray);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, Gcc_Coord_3d[] gcc_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            double d = Math.PI / 180 * gdc_Coord_3dArray[n].latitude;
            double d2 = Math.PI / 180 * gdc_Coord_3dArray[n].longitude;
            double d3 = Math.sin(d);
            double d4 = d3 * d3;
            double d5 = Math.cos(d);
            double d6 = A / (0.25 - Eps25 * d4 + 0.249998608869975 + (0.25 - Eps25 * d4) / (0.25 - Eps25 * d4 + 0.249998608869975));
            double d7 = d6 + gdc_Coord_3dArray[n].elevation;
            gcc_Coord_3dArray[n].x = d7 * d5 * Math.cos(d2);
            gcc_Coord_3dArray[n].y = d7 * d5 * Math.sin(d2);
            gcc_Coord_3dArray[n].z = (C2 / A2 * d6 + gdc_Coord_3dArray[n].elevation) * d3;
            ++n;
        }
    }
}

