/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gcc_Coord_3d;
import geotransform.coords.Gdc_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gcc_To_Gdc_Converter {
    static final double DEGREES_PER_RADIAN = 57.29577951308232;
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static double A;
    static double F;
    static double C;
    static double A2;
    static double C2;
    static double Eps2;
    static double Eps21;
    static double Eps25;
    static double C254;
    static double C2DA;
    static double CEE;
    static double CE2;
    static double CEEps2;
    static double TwoCEE;
    static double tem;
    static double ARat1;
    static double ARat2;
    static double BRat1;
    static double BRat2;
    static double B1;
    static double B2;
    static double B3;
    static double B4;
    static double B5;
    private static Ellipsoid e;

    public static void Init(Ellipsoid ellipsoid) {
        e = ellipsoid;
        Gcc_To_Gdc_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        A = d;
        F = d2;
        A2 = A * A;
        F = 1.0 / F;
        C = A * (1.0 - F);
        C2 = C * C;
        Eps2 = F * (2.0 - F);
        Eps21 = Eps2 - 1.0;
        Eps25 = 0.25 * Eps2;
        C254 = 54.0 * C2;
        C2DA = C2 / A;
        CE2 = A2 - C2;
        tem = CE2 / C2;
        CEE = Eps2 * Eps2;
        TwoCEE = 2.0 * CEE;
        CEEps2 = Eps2 * CE2;
        ARat1 = Math.pow(A + 50005.0, 2.0);
        ARat2 = ARat1 / Math.pow(C + 50005.0, 2.0);
        BRat1 = Math.pow(A - 10005.0, 2.0);
        BRat2 = BRat1 / Math.pow(C - 10005.0, 2.0);
        switch (e.get_id()) {
            case 20: {
                B1 = 1.00225438677758;
                B2 = -3.9324690363393E-5;
                B3 = 2.41216653453483E11;
                B4 = 1.33733602228679E13;
                B5 = 0.984537701867943;
                return;
            }
            case 0: {
                B1 = 1.00224625101002;
                B2 = -3.90460083288143E-5;
                B3 = 2.40320189037138E11;
                B4 = 1.33719260538966E13;
                B5 = 0.984592458596161;
                return;
            }
            case 1: {
                B1 = 1.00224625075368;
                B2 = -3.90459999900173E-5;
                B3 = 2.40303394872251E11;
                B4 = 1.33709931084284E13;
                B5 = 0.984592460957268;
                return;
            }
            case 2: {
                B1 = 1.00225444204291;
                B2 = -3.93265865328642E-5;
                B3 = 2.41224183614829E11;
                B4 = 1.33734497953958E13;
                B5 = 0.984537329904682;
            }
            case 3: {
                B1 = 1.00224755857767;
                B2 = -3.90907329587448E-5;
                B3 = 2.40451345711468E11;
                B4 = 1.33714386800225E13;
                B5 = 0.984583658241425;
                return;
            }
            case 4: {
                B1 = 1.00224755848503;
                B2 = -3.90907295861776E-5;
                B3 = 2.40444817155162E11;
                B4 = 1.33710761751998E13;
                B5 = 0.984583659174593;
                return;
            }
            case 5: {
                B1 = 1.00227973833064;
                B2 = -4.01992216347506E-5;
                B3 = 2.43880311870541E11;
                B4 = 1.33706476542196E13;
                B5 = 0.984367129494488;
                return;
            }
            case 6: {
                B1 = 1.00229163655042;
                B2 = -4.06128691119799E-5;
                B3 = 2.45130859537107E11;
                B4 = 1.33694175832394E13;
                B5 = 0.984287099560456;
                return;
            }
            case 7: {
                B1 = 1.00223509569433;
                B2 = -3.86654527077781E-5;
                B3 = 2.391286505945E11;
                B4 = 1.33720475335561E13;
                B5 = 0.984667548438242;
            }
            case 8: {
                B1 = 1.0022350957137;
                B2 = -3.86654536421315E-5;
                B3 = 2.39130314228725E11;
                B4 = 1.33721404499933E13;
                B5 = 0.984667548190955;
                return;
            }
            case 9: {
                B1 = 1.00223509572519;
                B2 = -3.86654535736479E-5;
                B3 = 2.39130514500415E11;
                B4 = 1.33721515789086E13;
                B5 = 0.984667548183952;
                return;
            }
            case 10: {
                B1 = 1.00223509571418;
                B2 = -3.86654534742569E-5;
                B3 = 2.39130097288096E11;
                B4 = 1.33721283147546E13;
                B5 = 0.984667548227722;
                return;
            }
            case 11: {
                B1 = 1.00223509572941;
                B2 = -3.86654536185472E-5;
                B3 = 2.39130725532003E11;
                B4 = 1.33721633543519E13;
                B5 = 0.984667548165743;
                return;
            }
            case 12: {
                B1 = 1.00225438677758;
                B2 = -3.9324690363393E-5;
                B3 = 2.41216653453483E11;
                B4 = 1.33733602228679E13;
                B5 = 0.984537701867943;
                return;
            }
            case 13: {
                B1 = 1.00225405980964;
                B2 = -3.93134714450825E-5;
                B3 = 2.41187107678002E11;
                B4 = 1.3373662221859E13;
                B5 = 0.984539902154414;
                return;
            }
            case 14: {
                B1 = 1.00226404159165;
                B2 = -3.96566479838024E-5;
                B3 = 2.42239266725463E11;
                B4 = 1.33727724324161E13;
                B5 = 0.98447273282124;
                return;
            }
            case 15: {
                B1 = 1.00226404171336;
                B2 = -3.96566527027543E-5;
                B3 = 2.4224821683171E11;
                B4 = 1.33732658091673E13;
                B5 = 0.984472731538793;
                return;
            }
            case 16: {
                B1 = 1.00225405984221;
                B2 = -3.93134735007025E-5;
                B3 = 2.41190507521621E11;
                B4 = 1.3373850552785E13;
                B5 = 0.984539901633388;
                return;
            }
            case 17: {
                B1 = 1.0022543867985;
                B2 = -3.93246905835223E-5;
                B3 = 2.41216653573729E11;
                B4 = 1.33733601038204E13;
                B5 = 0.98453770181006;
                return;
            }
            case 18: {
                B1 = 1.00225444204291;
                B2 = -3.93265865328642E-5;
                B3 = 2.41224183614829E11;
                B4 = 1.33734497953958E13;
                B5 = 0.984537329904682;
                return;
            }
            case 19: {
                B1 = 1.00225436554849;
                B2 = -3.93239617638985E-5;
                B3 = 2.41214275377192E11;
                B4 = 1.33733543378504E13;
                B5 = 0.984537844768728;
                return;
            }
        }
    }

    public static void Convert(Gcc_Coord_3d gcc_Coord_3d, Gdc_Coord_3d gdc_Coord_3d) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        Gcc_Coord_3d[] gcc_Coord_3dArray = new Gcc_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        gcc_Coord_3dArray[0] = gcc_Coord_3d;
        Gcc_To_Gdc_Converter.Convert(gcc_Coord_3dArray, gdc_Coord_3dArray);
    }

    public static void Convert(Gcc_Coord_3d[] gcc_Coord_3dArray, Gdc_Coord_3d[] gdc_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            double d;
            double d2;
            double d3;
            if (gcc_Coord_3dArray[n].x == 0.0) {
                if (gcc_Coord_3dArray[n].y > 0.0) {
                    gdc_Coord_3dArray[n].latitude = 1.5707963267948966;
                } else if (gcc_Coord_3dArray[n].y < 0.0) {
                    gdc_Coord_3dArray[n].longitude = -1.5707963267948966;
                } else {
                    if (gcc_Coord_3dArray[n].z > 0.0) {
                        gdc_Coord_3dArray[n].latitude = 1.5707963267948966;
                        gdc_Coord_3dArray[n].longitude = 0.0;
                        gdc_Coord_3dArray[n].elevation = gcc_Coord_3dArray[n].z;
                        return;
                    }
                    if (gcc_Coord_3dArray[n].z < 0.0) {
                        gdc_Coord_3dArray[n].latitude = -1.5707963267948966;
                        gdc_Coord_3dArray[n].longitude = 0.0;
                        gdc_Coord_3dArray[n].elevation = gcc_Coord_3dArray[n].z;
                        return;
                    }
                    gdc_Coord_3dArray[n].latitude = 0.0;
                    gdc_Coord_3dArray[n].longitude = 0.0;
                    gdc_Coord_3dArray[n].elevation = 0.0;
                    return;
                }
            }
            double d4 = gcc_Coord_3dArray[n].x * gcc_Coord_3dArray[n].x + gcc_Coord_3dArray[n].y * gcc_Coord_3dArray[n].y;
            double d5 = Math.sqrt(d4);
            double d6 = gcc_Coord_3dArray[n].z * gcc_Coord_3dArray[n].z;
            double d7 = d4 + ARat2 * d6;
            double d8 = d4 + BRat2 * d6;
            if (d8 > BRat1 && d7 < ARat1) {
                d3 = gcc_Coord_3dArray[n].z * (B1 + (B2 * d4 + B3) / (B4 + d4 * B5 + d6));
                double d9 = d3 * d3;
                double d10 = d9 + d4;
                d2 = Math.sqrt(d10);
                double d11 = d9 / d10;
                double d12 = A / (0.25 - Eps25 * d11 + 0.249998608869975 + (0.25 - Eps25 * d11) / (0.25 - Eps25 * d11 + 0.249998608869975));
                d = d3 / d2;
                gdc_Coord_3dArray[n].elevation = d11 < 0.5 ? d2 - d12 : gcc_Coord_3dArray[n].z / d + Eps21 * d12;
                gdc_Coord_3dArray[n].latitude = Math.atan(d3 / d5);
                gdc_Coord_3dArray[n].longitude = Math.atan2(gcc_Coord_3dArray[n].y, gcc_Coord_3dArray[n].x);
            } else {
                double d13 = gcc_Coord_3dArray[n].x * gcc_Coord_3dArray[n].x + gcc_Coord_3dArray[n].y * gcc_Coord_3dArray[n].y;
                double d14 = gcc_Coord_3dArray[n].z * gcc_Coord_3dArray[n].z;
                double d15 = Math.sqrt(d13);
                double d16 = C254 * d14;
                double d17 = d13 - Eps21 * d14 - CEEps2;
                double d18 = d16 / (d17 * d17);
                double d19 = CEE * d13 * d18 / d17;
                double d20 = d19 * (d19 + 2.0);
                d = 1.0 + d19 + Math.sqrt(d20);
                double d21 = Math.pow(d, 0.3333333333333333);
                double d22 = d18 / (3.0 * Math.pow(d21 + 1.0 / d21 + 1.0, 2.0));
                double d23 = 1.0 + TwoCEE * d22;
                d2 = Math.sqrt(d23);
                double d24 = -d22 * (2.0 * (1.0 - Eps2) * d14 / (d2 * (1.0 + d2)) + d13);
                double d25 = 1.0 + 1.0 / d2;
                double d26 = d25 + (d24 /= A2) > 0.0 ? A * Math.sqrt(0.5 * (d25 + d24)) : 0.0;
                double d27 = Math.pow(d15 - Eps2 * (d26 -= d22 * Eps2 * d15 / (1.0 + d2)), 2.0) + d14;
                double d28 = Eps2 * d26;
                double d29 = Math.pow(d15 - d28, 2.0) + d14;
                double d30 = Math.sqrt(d29 - Eps2 * d14);
                double d31 = C2DA * gcc_Coord_3dArray[n].z / d30;
                gdc_Coord_3dArray[n].elevation = Math.sqrt(d29) * (1.0 - C2DA / d30);
                d3 = gcc_Coord_3dArray[n].z + tem * d31;
                gdc_Coord_3dArray[n].latitude = Math.atan(d3 / d15);
                gdc_Coord_3dArray[n].longitude = Math.atan2(gcc_Coord_3dArray[n].y, gcc_Coord_3dArray[n].x);
            }
            gdc_Coord_3dArray[n].latitude *= 57.29577951308232;
            gdc_Coord_3dArray[n].longitude *= 57.29577951308232;
            ++n;
        }
    }
}

