/*
 * Decompiled with CFR 0.152.
 */
import geotransform.coords.Gcc_Coord_3d;
import org.web3d.geovrml.GeoVRML;
import org.web3d.geovrml.Quaternion;
import vrml.Event;
import vrml.field.ConstSFBool;
import vrml.field.ConstSFRotation;
import vrml.field.ConstSFString;
import vrml.field.ConstSFVec3f;
import vrml.field.MFFloat;
import vrml.field.MFString;
import vrml.field.SFBool;
import vrml.field.SFFloat;
import vrml.field.SFNode;
import vrml.field.SFRotation;
import vrml.field.SFString;
import vrml.field.SFTime;
import vrml.field.SFVec3f;
import vrml.node.Node;
import vrml.node.Script;

public class GeoViewpoint
extends Script {
    Node viewpoint;
    Node navinfo;
    boolean debug = false;
    Gcc_Coord_3d gcc;
    GeoVRML geovrml;
    MFString geoSystem;
    SFBool isBound;
    SFTime bindTime;
    SFRotation last_rot;

    private void process_position(SFString sFString) {
        this.gcc = this.geovrml.getCoord(sFString, this.geoSystem);
        if (this.debug) {
            System.out.println(" new viewpoint pos: " + this.gcc.x + ", " + this.gcc.y + ", " + this.gcc.z);
        }
        SFVec3f sFVec3f = (SFVec3f)this.viewpoint.getExposedField("position");
        sFVec3f.setValue((float)this.gcc.x, (float)this.gcc.y, (float)this.gcc.z);
    }

    private void process_orientation(SFRotation sFRotation) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        this.last_rot = null;
        this.last_rot = sFRotation;
        this.geovrml.getLocalOrientation(this.gcc, fArray);
        sFRotation.getValue(fArray2);
        fArray[3] = (float)((double)fArray[3] * 57.29577951308232);
        fArray2[3] = (float)((double)fArray2[3] * 57.29577951308232);
        Quaternion quaternion = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        Quaternion quaternion3 = new Quaternion();
        quaternion.rotation(fArray[0], fArray[1], fArray[2], fArray[3]);
        quaternion2.rotation(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
        quaternion3.add(quaternion2, quaternion);
        double[] dArray = new double[3];
        double d = quaternion3.axis_angle(dArray);
        float[] fArray3 = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2], (float)d};
        if (this.debug) {
            System.out.println(" new viewpoint orient: " + fArray3[0] + ", " + fArray3[1] + ", " + fArray3[2] + ", " + fArray3[3]);
        }
        SFRotation sFRotation2 = (SFRotation)this.viewpoint.getExposedField("orientation");
        sFRotation2.setValue(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
    }

    public void new_camera(double d, double d2, double d3) {
        double d4 = this.geovrml.getElevation(d, d2, d3);
        float f = (float)d4 / 10.0f;
        SFFloat sFFloat = (SFFloat)this.navinfo.getExposedField("speed");
        sFFloat.setValue(f);
        float[] fArray = new float[]{0.25f * f, 1.6f * f, 0.75f * f};
        MFFloat mFFloat = (MFFloat)this.navinfo.getExposedField("avatarSize");
        mFFloat.setValue(3, fArray);
        if (this.debug) {
            System.out.println("Camera moved: elev = " + d4 + " m, speed = " + f + " m/s");
        }
    }

    public void processEvent(Event event) {
        Object object;
        ConstSFBool constSFBool;
        if (this.debug) {
            System.out.println("Event received: " + event.getName());
        }
        if (event.getName().equals("set_bind")) {
            constSFBool = (ConstSFBool)event.getValue();
            object = (SFBool)this.viewpoint.getEventIn("set_bind");
            object.setValue(constSFBool);
            object = (SFBool)this.navinfo.getEventIn("set_bind");
            object.setValue(constSFBool);
            object = (SFBool)this.viewpoint.getExposedField("enabled");
            object.setValue(constSFBool);
            this.isBound.setValue(constSFBool);
            this.bindTime.setValue(event.getTimeStamp());
        }
        if (event.getName().equals("set_position")) {
            object = (ConstSFString)event.getValue();
            constSFBool = new SFString(object.getValue());
            this.process_position((SFString)constSFBool);
            this.process_orientation(this.last_rot);
        }
        if (event.getName().equals("set_orientation")) {
            object = new float[4];
            ((ConstSFRotation)event.getValue()).getValue((float[])object);
            constSFBool = new SFRotation((float)object[0], (float)object[1], (float)object[2], (float)object[3]);
            this.process_orientation((SFRotation)constSFBool);
        }
        if (event.getName().equals("position_changed")) {
            object = new float[3];
            ((ConstSFVec3f)event.getValue()).getValue((float[])object);
            this.new_camera((double)object[0], (double)object[1], (double)object[2]);
        }
    }

    public void processEvents(int n, Event[] eventArray) {
        int n2 = 0;
        while (n2 < n) {
            if (eventArray[n2].getName().equals("set_position")) {
                this.processEvent(eventArray[n2]);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!eventArray[n3].getName().equals("set_position")) {
                this.processEvent(eventArray[n3]);
            }
            ++n3;
        }
    }

    public void initialize() {
        SFNode sFNode = (SFNode)this.getField("geoOrigin");
        SFString sFString = (SFString)this.getField("position");
        SFRotation sFRotation = (SFRotation)this.getField("orientation");
        this.geoSystem = (MFString)this.getField("geoSystem");
        this.viewpoint = (Node)((SFNode)this.getField("viewpoint")).getValue();
        this.navinfo = (Node)((SFNode)this.getField("navinfo")).getValue();
        this.debug = ((SFBool)this.getField("debug")).getValue();
        this.isBound = (SFBool)this.getEventOut("isBound");
        this.bindTime = (SFTime)this.getEventOut("bindTime");
        if (this.debug) {
            System.out.println("GeoViewpoint:");
        }
        try {
            this.geovrml = new GeoVRML();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("GeoTransform classes not installed in CLASSPATH!");
            return;
        }
        this.geovrml.setOrigin(sFNode);
        this.process_position(sFString);
        this.process_orientation(sFRotation);
        this.new_camera(this.gcc.x, this.gcc.y, this.gcc.z);
    }
}

