/*
 * Decompiled with CFR 0.152.
 */
import geotransform.coords.Gcc_Coord_3d;
import org.web3d.geovrml.GeoVRML;
import vrml.Event;
import vrml.field.ConstSFFloat;
import vrml.field.MFFloat;
import vrml.field.MFString;
import vrml.field.SFBool;
import vrml.field.SFNode;
import vrml.field.SFString;
import vrml.field.SFVec3f;
import vrml.node.Script;

public class GeoPositionInterpolator
extends Script {
    SFVec3f value_changed;
    SFString geovalue_changed;
    String[] keyValue;
    int keyValueSize;
    float[] key;
    int keySize;
    String geo_system;
    boolean debug = false;
    GeoVRML geovrml;

    public void processEvent(Event event) {
        String string;
        float f = ((ConstSFFloat)event.getValue()).getValue();
        if (this.debug) {
            System.out.println("  got fraction " + f);
        }
        if (this.keySize < 1) {
            return;
        }
        if (f <= this.key[0] || this.keySize < 2) {
            string = this.keyValue[0];
            if (this.debug) {
                System.out.println("  first value = " + string);
            }
        } else if (f >= this.key[this.keySize - 1]) {
            string = this.keyValue[this.keySize - 1];
            if (this.debug) {
                System.out.println("  last value = " + string);
            }
        } else {
            int n = 0;
            while (n < this.keySize - 1) {
                if (f <= this.key[n + 1]) break;
                ++n;
            }
            float f2 = (f - this.key[n]) / (this.key[n + 1] - this.key[n]);
            if (this.debug) {
                System.out.println("  linterp index = " + n);
            }
            string = this.geovrml.linterp(this.keyValue[n], this.keyValue[n + 1], f2, this.geo_system);
            if (this.debug) {
                System.out.println("  linterp value = " + string);
            }
        }
        Gcc_Coord_3d gcc_Coord_3d = this.geovrml.getCoord(string, this.geo_system);
        this.value_changed.setValue((float)gcc_Coord_3d.x, (float)gcc_Coord_3d.y, (float)gcc_Coord_3d.z);
        if (this.debug) {
            System.out.println("  output = " + gcc_Coord_3d.x + ", " + gcc_Coord_3d.y + ", " + gcc_Coord_3d.z);
        }
        this.geovalue_changed.setValue(string);
    }

    public void initialize() {
        SFNode sFNode = (SFNode)this.getField("geoOrigin");
        MFString mFString = (MFString)this.getField("geoSystem");
        this.value_changed = (SFVec3f)this.getEventOut("value_changed");
        this.geovalue_changed = (SFString)this.getEventOut("geovalue_changed");
        this.debug = ((SFBool)this.getField("debug")).getValue();
        if (this.debug) {
            System.out.println("GeoPositionInterpolator:");
        }
        MFFloat mFFloat = (MFFloat)this.getField("key");
        this.keySize = mFFloat.getSize();
        this.key = new float[this.keySize];
        mFFloat.getValue(this.key);
        if (this.debug) {
            System.out.println("  got key array");
        }
        MFString mFString2 = (MFString)this.getField("keyValue");
        this.keyValueSize = mFString2.getSize();
        this.keyValue = new String[this.keyValueSize];
        mFString2.getValue(this.keyValue);
        if (this.debug) {
            System.out.println("  got keyValue array");
        }
        try {
            this.geovrml = new GeoVRML();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("GeoTransform classes not installed in CLASSPATH!");
            return;
        }
        this.geovrml.setOrigin(sFNode);
        this.geo_system = GeoVRML.VRMLToString(mFString);
    }
}

